/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@TestForIssue(jiraKey="HSEARCH-1744")
@Category(value={SkipOnElasticsearch.class})
public class TwoWayFieldBridgeTest {
    @Test
    public void testTwoWayFieldBridgeCanHandleNullInObjectToString() throws Exception {
        List<Class<?>> classes = this.getClasses("org.hibernate.search.bridge.builtin");
        Assert.assertTrue((String)"Guarding against a package refactoring", (classes.size() > 0 ? 1 : 0) != 0);
        for (Class<?> clazz : classes) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !TwoWayFieldBridge.class.isAssignableFrom(clazz)) continue;
            if (Enum.class.isAssignableFrom(clazz)) {
                Assert.assertTrue((String)("Unexpected enum class" + clazz), (boolean)NumericFieldBridge.class.isAssignableFrom(clazz));
                Class<?> enclosingClass = clazz.getEnclosingClass();
                if (enclosingClass == null) continue;
                for (Object o : enclosingClass.getEnumConstants()) {
                    TwoWayFieldBridge bridge = (TwoWayFieldBridge)o;
                    Assert.assertEquals((String)"All TwoWayFieldBridgeTest should return 'null' for 'null' passed to 'objectToString", null, (Object)bridge.objectToString(null));
                }
                continue;
            }
            TwoWayFieldBridge bridge = (TwoWayFieldBridge)clazz.newInstance();
            Assert.assertEquals((String)"All TwoWayFieldBridgeTest should return 'null' for 'null' passed to 'objectToString", null, (Object)bridge.objectToString(null));
        }
    }

    private List<Class<?>> getClasses(String packageName) throws ClassNotFoundException, IOException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = TwoWayFieldBridgeTest.class.getClassLoader().getResources(path);
        ArrayList<File> directories = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            directories.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : directories) {
            for (String classFileName : directory.list(new ClassFilenameFilter())) {
                classes.add(Class.forName(packageName + '.' + classFileName.substring(0, classFileName.length() - 6)));
            }
        }
        return classes;
    }

    public static class ClassFilenameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".class");
        }
    }
}

