/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.OffsetTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OffsetTimeBridgeTest {
    private static final OffsetTimeBridge BRIDGE = OffsetTimeBridge.INSTANCE;
    private static final String MAX = "235959999999999+18:00";
    private static final String MIN = "000000000000000-18:00";
    private static final String CUSTOM = "040506000000007+08:00";
    private static final OffsetTime MAX_UTC = OffsetTime.of(LocalTime.MAX, ZoneOffset.MAX);
    private static final OffsetTime MIN_UTC = OffsetTime.of(LocalTime.MIN, ZoneOffset.MIN);
    private static final OffsetTime CUSTOM_UTC = OffsetTime.of(LocalTime.of(4, 5, 6, 7), ZoneOffset.ofHours(8));
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_UTC)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_UTC)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_UTC)).isEqualTo((Object)CUSTOM);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_UTC);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_UTC);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CUSTOM)).isEqualTo((Object)CUSTOM_UTC);
    }
}

