/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.fest.assertions.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.ZonedDateTimeBridge;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZonedDateTimeBridgeTest {
    private static final ZonedDateTimeBridge BRIDGE = ZonedDateTimeBridge.INSTANCE;
    private static final String MAX = "+9999999991231235959999999999+18:00";
    private static final String MIN = "-9999999990101000000000000000-18:00";
    private static final String CUSTOM_LEGACY_FORMAT = "+0000020010203040506000000007Europe/Paris";
    private static final String CUSTOM = "+0000020010203040506000000007+01:00Europe/Paris";
    private static final String BC_CUSTOM_LEGACY_FORMAT = "-0000000010203040506000000007Europe/Paris";
    private static final String BC_CUSTOM = "-0000000010203040506000000007+00:09:21Europe/Paris";
    private static final ZonedDateTime MAX_VALUE = ZonedDateTime.of(LocalDateTime.MAX, ZoneOffset.MAX);
    private static final ZonedDateTime MIN_VALUE = ZonedDateTime.of(LocalDateTime.MIN, ZoneOffset.MIN);
    private static final ZonedDateTime CUSTOM_VALUE = ZonedDateTime.of(LocalDate.of(2001, 2, 3), LocalTime.of(4, 5, 6, 7), ZoneId.of("Europe/Paris"));
    private static final ZonedDateTime BC_CUSTOM_VALUE = ZonedDateTime.of(LocalDate.of(-1, 2, 3), LocalTime.of(4, 5, 6, 7), ZoneId.of("Europe/Paris"));
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_VALUE)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_VALUE)).isEqualTo((Object)MIN);
    }

    @Test
    public void testCustomObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_VALUE)).isEqualTo((Object)CUSTOM);
    }

    @Test
    public void testBcCustomObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)BC_CUSTOM_VALUE)).isEqualTo((Object)BC_CUSTOM);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_VALUE);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_VALUE);
    }

    @Test
    public void testCustomStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CUSTOM)).isEqualTo((Object)CUSTOM_VALUE);
    }

    @Test
    public void testCustomLegacyStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CUSTOM_LEGACY_FORMAT)).isEqualTo((Object)CUSTOM_VALUE);
    }

    @Test
    public void testBcCustomStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(BC_CUSTOM)).isEqualTo((Object)BC_CUSTOM_VALUE);
    }

    @Test
    public void testBcCustomLegacyStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(BC_CUSTOM_LEGACY_FORMAT)).isEqualTo((Object)BC_CUSTOM_VALUE);
    }
}

