/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.ExplicitOnlyOptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class OptimizerStrategyLoadTest {
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void testDefaultImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", "default");
        this.verifyOptimizerImplementationIs(ExplicitOnlyOptimizerStrategy.class, cfg);
    }

    @Test
    public void testUnsetImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        this.verifyOptimizerImplementationIs(ExplicitOnlyOptimizerStrategy.class, cfg);
    }

    @Test
    public void testIncrementalImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.optimizer.transaction_limit.max", "5");
        this.verifyOptimizerImplementationIs(IncrementalOptimizerStrategy.class, cfg);
    }

    @Test(expected=SearchException.class)
    public void testIllegalImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", "5");
        this.verifyOptimizerImplementationIs(IncrementalOptimizerStrategy.class, cfg);
    }

    @Test
    public void testValidExtension() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", CustomOptimizer.class.getName());
        this.verifyOptimizerImplementationIs(CustomOptimizer.class, cfg);
    }

    private void verifyOptimizerImplementationIs(Class type, SearchConfigurationForTest cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addClass(Document.class);
        ExtendedSearchIntegrator sf = this.integratorResource.create(cfg);
        EntityIndexBinding indexBindingForEntity = (EntityIndexBinding)sf.getIndexBindings().get(Document.class);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagerSelector().all().iterator().next();
        OptimizerStrategy optimizerStrategy = indexManager.getOptimizerStrategy();
        Assert.assertTrue((boolean)type.isAssignableFrom(optimizerStrategy.getClass()));
    }

    public static final class CustomOptimizer
    extends IncrementalOptimizerStrategy {
    }

    public static final class Document {
        private long id;
        private String title;
    }
}

