/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.test.configuration.mutablefactory.B;
import org.hibernate.search.test.configuration.mutablefactory.C;
import org.hibernate.search.test.configuration.mutablefactory.generated.Generated;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class MutableFactoryTest {
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    private SearchIntegrator searchIntegrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.searchIntegrator);

    @Test
    public void testCreateEmptyFactory() throws Exception {
        this.integratorResource.create(new SearchConfigurationForTest());
    }

    @Test
    public void testAddingClassFullModel() throws Exception {
        this.searchIntegrator = this.integratorResource.create(new SearchConfigurationForTest());
        this.searchIntegrator = this.integratorResource.create(this.searchIntegrator, A.class);
        this.helper.index((Object)new A(1, "Emmanuel"), Integer.valueOf(1));
        this.helper.assertThat("name", "emmanuel").from(A.class).hasResultSize(1);
        this.searchIntegrator = this.integratorResource.create(this.searchIntegrator, B.class);
        this.helper.index((Object)new B(1, "Noel"), Integer.valueOf(1));
        this.helper.assertThat("name", "noel").from(B.class).hasResultSize(1);
    }

    @Test
    public void testAddingClassSimpleAPI() throws Exception {
        this.searchIntegrator = this.integratorResource.create(new SearchConfigurationForTest());
        this.searchIntegrator.addClasses(new Class[]{A.class});
        this.helper.index((Object)new A(1, "Emmanuel"), Integer.valueOf(1));
        this.helper.assertThat("name", "emmanuel").from(A.class).hasResultSize(1);
        this.searchIntegrator.addClasses(new Class[]{B.class, C.class});
        this.helper.index().push((Object)new B(1, "Noel"), Integer.valueOf(1)).push((Object)new C(1, "Vincent"), Integer.valueOf(1)).execute();
        this.helper.assertThat("name", "noel").from(B.class).hasResultSize(1);
        this.helper.assertThat("name", "vincent").from(C.class).hasResultSize(1);
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void testAddingClassSimpleAPIwithJMX() throws Exception {
        this.searchIntegrator = this.integratorResource.create(new SearchConfigurationForTest().addClass(A.class).addProperty("hibernate.search.jmx_enabled", Boolean.TRUE.toString()).addProperty("hibernate.search.generate_statistics", Boolean.TRUE.toString()).addProperty("com.sun.management.jmxremote", Boolean.TRUE.toString()));
        this.helper.index((Object)new A(1, "Emmanuel"), Integer.valueOf(1));
        this.helper.assertThat("name", "emmanuel").from(A.class).hasResultSize(1);
        Assert.assertEquals((long)1L, (long)this.searchIntegrator.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)1L, (long)this.searchIntegrator.getStatistics().getIndexedClassNames().size());
        this.searchIntegrator.addClasses(new Class[]{B.class, C.class});
        this.helper.index().push((Object)new B(1, "Noel"), Integer.valueOf(1)).push((Object)new C(1, "Vincent"), Integer.valueOf(1)).execute();
        this.helper.assertThat("name", "noel").from(A.class, B.class, C.class).hasResultSize(1);
        Assert.assertEquals((long)2L, (long)this.searchIntegrator.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)3L, (long)this.searchIntegrator.getStatistics().getIndexedClassNames().size());
        this.helper.assertThat("name", "vincent").from(A.class, B.class, C.class).hasResultSize(1);
        Assert.assertEquals((long)3L, (long)this.searchIntegrator.getStatistics().getSearchQueryExecutionCount());
        Assert.assertEquals((long)3L, (long)this.searchIntegrator.getStatistics().getIndexedClassNames().size());
    }

    @Test
    public void testMultiThreadedAddClasses() throws Exception {
        this.searchIntegrator = this.integratorResource.create(new SearchConfigurationForTest());
        int numberOfClasses = 100;
        int numberOfThreads = 10;
        new ConcurrentRunner(numberOfClasses, numberOfThreads, new ConcurrentRunner.TaskFactory(){

            @Override
            public Runnable createRunnable(int i) throws Exception {
                return new DoAddClass(i);
            }
        }).setTimeout(1L, TimeUnit.MINUTES).execute();
        for (int i = 0; i < numberOfClasses; ++i) {
            Class<?> classByNumber = MutableFactoryTest.getClassByNumber(i, this.searchIntegrator.getServiceManager());
            this.helper.assertThat("name", "emmanuel" + i).from(classByNumber).hasResultSize(1);
        }
    }

    private static Class<?> getClassByNumber(int i, ServiceManager serviceManager) throws ClassNotFoundException {
        ClassLoaderService classLoaderService = serviceManager.getClassLoaderService();
        Class clazz = classLoaderService.classForName(Generated.A0.class.getName().replace("A0", "A" + i));
        return clazz;
    }

    private class DoAddClass
    implements Runnable {
        private final int index;

        public DoAddClass(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            try {
                String name = "Emmanuel" + this.index;
                Class aClass = MutableFactoryTest.getClassByNumber(this.index, MutableFactoryTest.this.searchIntegrator.getServiceManager());
                System.err.println("Creating index #" + this.index + " for class " + aClass);
                MutableFactoryTest.this.searchIntegrator.addClasses(new Class[]{aClass});
                Object entity = aClass.getConstructor(Integer.class, String.class).newInstance(this.index, name);
                MutableFactoryTest.this.helper.index(entity, Integer.valueOf(this.index));
                EntityIndexBinding indexBindingForEntity = (EntityIndexBinding)MutableFactoryTest.this.searchIntegrator.getIndexBindings().get(aClass);
                Assert.assertNotNull((Object)indexBindingForEntity);
                Set indexManagers = indexBindingForEntity.getIndexManagerSelector().all();
                Assert.assertEquals((long)1L, (long)indexManagers.size());
                MutableFactoryTest.this.helper.assertThat("name", "emmanuel" + this.index).from(aClass).hasResultSize(1);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException("Unexpected exception while manipulating dynamically created classes", e);
            }
        }
    }
}

