/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.Unit;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.test.dsl.POI;
import org.hibernate.search.test.dsl.POIHash;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SpatialDSLTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(POI.class, POIHash.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void setUp() throws Exception {
        this.indexTestData();
    }

    @Test
    public void testSpatialRangeQueries() {
        QueryBuilder builder = this.helper.queryBuilder(POI.class);
        Point coordinates = Point.fromDegrees((double)24.0, (double)31.5);
        Query query = builder.spatial().onField("location").within(51.0, Unit.KM).ofCoordinates((Coordinates)coordinates).createQuery();
        this.helper.assertThat(query).from(POI.class).matchesExactlyIds(Integer.valueOf(2));
        query = builder.spatial().onField("location").within(500.0, Unit.KM).ofLatitude(48.858333).andLongitude(2.294444).createQuery();
        this.helper.assertThat(query).from(POI.class).matchesExactlyIds(Integer.valueOf(1));
    }

    @Test
    public void testSpatialHashQueries() {
        QueryBuilder builder = this.helper.queryBuilder(POIHash.class);
        Point coordinates = Point.fromDegrees((double)24.0, (double)31.5);
        Query query = builder.spatial().onField("location").within(51.0, Unit.KM).ofCoordinates((Coordinates)coordinates).createQuery();
        this.helper.assertThat(query).from(POIHash.class).matchesExactlyIds(Integer.valueOf(2));
        query = builder.spatial().onField("location").within(500.0, Unit.KM).ofLatitude(48.858333).andLongitude(2.294444).createQuery();
        this.helper.assertThat(query).from(POIHash.class).matchesExactlyIds(Integer.valueOf(1));
    }

    private void indexTestData() {
        POI poi = new POI(1, "Tour Eiffel", 48.858333, 2.294444, "Monument");
        this.helper.add(poi);
        poi = new POI(2, "Bozo", 24.0, 32.0, "Monument");
        this.helper.add(poi);
        POIHash poiHash = new POIHash(1, "Tour Eiffel", 48.858333, 2.294444, "Monument");
        this.helper.add(poiHash);
        poiHash = new POIHash(2, "Bozo", 24.0, 32.0, "Monument");
        this.helper.add(poiHash);
    }
}

