/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.typehandling;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.junit.Assert;
import org.junit.Test;

public class BasicTypeCollectionsTest {
    private static final IndexedTypeIdentifier TYPE_A = new PojoIndexedTypeIdentifier(BasicTypeCollectionsTest.class);
    private static final IndexedTypeIdentifier TYPE_B = new PojoIndexedTypeIdentifier(String.class);

    @Test
    public void emptyStream() {
        this.assertIsEmpty((IndexedTypeSet)Collections.emptyList().stream().collect(IndexedTypeSets.streamCollector()));
    }

    @Test
    public void nullVararg() {
        this.assertIsEmpty(IndexedTypeSets.fromClasses(null));
    }

    @Test
    public void emptyArray() {
        this.assertIsEmpty(IndexedTypeSets.fromIdentifiers((IndexedTypeIdentifier[])new IndexedTypeIdentifier[0]));
    }

    @Test
    public void emptyIterable() {
        this.assertIsEmpty(IndexedTypeSets.fromIdentifiers(Collections.emptyList()));
    }

    @Test
    public void singleElementClass() {
        this.assertIsSingletonSet(IndexedTypeSets.fromClass(BasicTypeCollectionsTest.class), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void singleElementIterable() {
        this.assertIsSingletonSet(IndexedTypeSets.fromIdentifiers((Iterable)TYPE_A.asTypeSet()), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void singleElementStream() {
        this.assertIsSingletonSet((IndexedTypeSet)Collections.singleton(TYPE_A).stream().collect(IndexedTypeSets.streamCollector()), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void singleElementArray() {
        this.assertIsSingletonSet(IndexedTypeSets.fromIdentifiers((IndexedTypeIdentifier[])new IndexedTypeIdentifier[]{TYPE_A}), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void compositeEmpty() {
        this.assertIsEmpty(IndexedTypeSets.composite((IndexedTypeSet)IndexedTypeSets.empty(), (IndexedTypeSet)IndexedTypeSets.empty()));
    }

    @Test
    public void compositeSingle() {
        this.assertIsSingletonSet(IndexedTypeSets.composite((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeIdentifier)TYPE_A), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void compositeSingleAndEmpty() {
        this.assertIsSingletonSet(IndexedTypeSets.composite((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeSet)IndexedTypeSets.empty()), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void subtractionEmpty() {
        this.assertIsEmpty(IndexedTypeSets.subtraction((IndexedTypeSet)IndexedTypeSets.empty(), (IndexedTypeSet)IndexedTypeSets.empty()));
    }

    @Test
    public void subtractionOfSingletons() {
        this.assertIsEmpty(IndexedTypeSets.subtraction((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeSet)TYPE_A.asTypeSet()));
    }

    @Test
    public void subtractionOfSingletonFromEmpty() {
        this.assertIsEmpty(IndexedTypeSets.subtraction((IndexedTypeSet)IndexedTypeSets.empty(), (IndexedTypeSet)TYPE_A.asTypeSet()));
    }

    @Test
    public void subtractionOfEmptyFromSingleton() {
        this.assertIsSingletonSet(IndexedTypeSets.subtraction((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeSet)IndexedTypeSets.empty()), BasicTypeCollectionsTest.class, true);
    }

    @Test
    public void buildCoupleSet() {
        this.assertIsDoubleSet(IndexedTypeSets.composite((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeIdentifier)TYPE_B));
    }

    @Test
    public void subtractionOfOneFromCouple() {
        this.assertIsSingletonSet(IndexedTypeSets.subtraction((IndexedTypeSet)IndexedTypeSets.composite((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeIdentifier)TYPE_B), (IndexedTypeSet)TYPE_B.asTypeSet()), TYPE_A.getPojoType(), true);
        this.assertIsSingletonSet(IndexedTypeSets.subtraction((IndexedTypeSet)IndexedTypeSets.composite((IndexedTypeSet)TYPE_A.asTypeSet(), (IndexedTypeIdentifier)TYPE_B), (IndexedTypeSet)TYPE_A.asTypeSet()), TYPE_B.getPojoType(), true);
    }

    private void assertIsDoubleSet(IndexedTypeSet typeSet) {
        Assert.assertFalse((String)"Verify it's not a singleton", (typeSet == IndexedTypeSets.empty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)typeSet.isEmpty());
        Assert.assertEquals((long)2L, (long)typeSet.size());
        Iterator iterator = typeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedTypeIdentifier firstElement = (IndexedTypeIdentifier)iterator.next();
        IndexedTypeIdentifier secondElement = (IndexedTypeIdentifier)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.forEachRemaining(l -> Assert.fail((String)"should never happen"));
        Set pojosSet = typeSet.toPojosSet();
        Assert.assertTrue((boolean)pojosSet.contains(TYPE_A.getPojoType()));
        Assert.assertTrue((boolean)pojosSet.contains(TYPE_B.getPojoType()));
        Assert.assertEquals((long)2L, (long)pojosSet.size());
    }

    private void assertIsEmpty(IndexedTypeSet typeSet) {
        Assert.assertTrue((String)"Verify the singleton optimisation applies", (typeSet == IndexedTypeSets.empty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)typeSet.isEmpty());
        Assert.assertEquals((long)0L, (long)typeSet.size());
        typeSet.iterator().forEachRemaining(l -> Assert.fail((String)"should never happen"));
        Assert.assertEquals((long)0L, (long)typeSet.toPojosSet().size());
    }

    private void assertIsSingletonSet(IndexedTypeSet typeSet, Class<?> someType, boolean recursive) {
        Assert.assertFalse((String)"Verify it's not a singleton", (typeSet == IndexedTypeSets.empty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)typeSet.isEmpty());
        Assert.assertEquals((long)1L, (long)typeSet.size());
        Iterator iterator = typeSet.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        IndexedTypeIdentifier firstElement = (IndexedTypeIdentifier)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.forEachRemaining(l -> Assert.fail((String)"should never happen"));
        Set pojosSet = typeSet.toPojosSet();
        Assert.assertTrue((boolean)pojosSet.contains(someType));
        Assert.assertEquals((long)1L, (long)pojosSet.size());
        IndexedTypeSet typeSet2 = firstElement.asTypeSet();
        if (recursive) {
            this.assertIsSingletonSet(typeSet2, someType, false);
        }
        Assert.assertEquals((Object)typeSet2, (Object)typeSet2);
        Assert.assertEquals((Object)firstElement.getPojoType(), someType);
    }
}

