/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.test.metadata.Quux;
import org.hibernate.search.test.metadata.Qux;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1759")
public class FieldConfigurationTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testFieldAnnotationTargetingSameFieldAsDocumentIdIsNotAllowed() {
        try {
            this.metadataProvider.getTypeMetadataFor(Qux.class, (IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE);
            Assert.fail((String)"Invalid configuration should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000247"));
        }
    }

    @Test
    public void testFieldAnnotationAddsAdditionalFieldForIdProperty() {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, Quux.class);
        PropertyDescriptor propertyDescriptor = typeDescriptor.getProperty("id");
        Assert.assertEquals((String)"Unexpected number of fields", (long)2L, (long)propertyDescriptor.getIndexedFields().size());
    }
}

