/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.polymorphism;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PolymorhicIndexingTest {
    private Class[] knownTypes = new Class[]{RootIndexedA.class, RootIndexedB.class, ChildOfBIndexed.class, ChildOfBNotIndexed.class, RootNotIndexed.class, IndexedGrandChildOfB.class};
    @Rule
    public SearchFactoryHolder factoryHolder = new SearchFactoryHolder(this.knownTypes);

    @Test
    public void testSortingOnNumericInt() {
        this.expectingForArgument(new Class[0], new Class[0]);
        this.expectingForArgument(null, new Class[0]);
        this.expectingForArgument(new Class[]{Object.class}, RootIndexedA.class, RootIndexedB.class, ChildOfBIndexed.class, IndexedGrandChildOfB.class);
        this.expectingForArgument(new Class[]{RootIndexedA.class}, RootIndexedA.class);
        this.expectingForArgument(new Class[]{RootIndexedB.class}, RootIndexedB.class, ChildOfBIndexed.class, IndexedGrandChildOfB.class);
        this.expectingForArgument(new Class[]{ChildOfBNotIndexed.class}, IndexedGrandChildOfB.class);
        this.expectingForArgument(new Class[]{ChildOfBIndexed.class}, ChildOfBIndexed.class);
        this.expectingForArgument(new Class[]{IndexedGrandChildOfB.class}, IndexedGrandChildOfB.class);
    }

    private void expectingForArgument(Class[] argument, Class ... expectedInResult) {
        ExtendedSearchIntegrator searchIntegrator = this.factoryHolder.getSearchFactory();
        IndexedTypeSet set = searchIntegrator.getIndexedTypesPolymorphic(IndexedTypeSets.fromClasses((Class[])argument));
        IndexedTypeSet expectation = IndexedTypeSets.fromClasses((Class[])expectedInResult);
        Assert.assertEquals((Object)expectation, (Object)set);
    }

    class RootNotIndexed {
        RootNotIndexed() {
        }
    }

    @Indexed
    class IndexedGrandChildOfB
    extends ChildOfBNotIndexed {
        IndexedGrandChildOfB() {
        }
    }

    class ChildOfBNotIndexed
    extends RootIndexedB {
        ChildOfBNotIndexed() {
        }
    }

    @Indexed
    class ChildOfBIndexed
    extends RootIndexedB {
        ChildOfBIndexed() {
        }
    }

    @Indexed
    class RootIndexedB {
        @DocumentId
        int someOtherId;
        @Field
        String name;

        RootIndexedB() {
        }
    }

    @Indexed
    class RootIndexedA {
        @DocumentId
        int id;
        @Field
        int age;

        RootIndexedA() {
        }
    }
}

