/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.projection;

import java.util.Locale;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-1786")
public class ProjectionConversionTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(ExampleEntity.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Before
    public void storeTestData() {
        ExampleEntity entity = new ExampleEntity();
        entity.id = 1L;
        entity.someInteger = 5;
        entity.longEncodedAsText = 20L;
        entity.unstoredField = "unstoredField";
        entity.customBridgedKeyword = "lowercase-keyword";
        entity.customOneWayBridgedKeyword = "lowercase-keyword";
        entity.customTwoWayBridgedKeywordWithMetadataOverride = "lowercase-keyword";
        ExampleEntity embedded = new ExampleEntity();
        embedded.id = 2L;
        embedded.someInteger = 6;
        embedded.longEncodedAsText = 21L;
        embedded.unstoredField = "unstoredFieldEmbedded";
        embedded.customBridgedKeyword = "another-lowercase-keyword";
        embedded.customOneWayBridgedKeyword = "another-lowercase-keyword";
        embedded.customTwoWayBridgedKeywordWithMetadataOverride = "another-lowercase-keyword";
        ConflictingMappedType second = new ConflictingMappedType();
        second.id = "a string";
        second.customBridgedKeyword = 17L;
        entity.embedded = embedded;
        entity.second = second;
        this.helper.add(entity);
    }

    @Test
    public void projectingExplicitId() {
        this.projectionTestHelper("__HSearch_id", 1L);
    }

    @Test
    public void projectingIdByPropertyName() {
        this.projectionTestHelper("id", 1L);
    }

    @Test
    public void projectingIdOnOverloadedMapping() {
        this.projectionTestHelper("stringTypedId", 1L);
    }

    @Test
    public void projectingIntegerField() {
        this.projectionTestHelper("someInteger", 5);
    }

    @Test
    public void projectingUnknownField() {
        this.projectionTestHelper("someNonExistingField", null);
    }

    @Test
    @Category(value={ElasticsearchSupportInProgress.class})
    public void projectingUnstoredField() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000323");
        this.thrown.expectMessage("unstoredField");
        this.projectionTestHelper("unstoredField", null);
    }

    @Test
    public void projectionWithCustomBridge() {
        this.projectionTestHelper("customBridgedKeyword", "lowercase-keyword");
    }

    @Test
    public void projectionWithCustomOneWayBridge() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000324");
        this.thrown.expectMessage("customOneWayBridgedKeyword");
        this.thrown.expectMessage(CustomOneWayBridge.class.getName());
        this.projectionTestHelper("customOneWayBridgedKeyword", "lowercase-keyword");
    }

    @Test
    public void projectionWithCustomBridgeOverridingMetadata() {
        this.projectionTestHelper("customTwoWayBridgedKeywordWithMetadataOverride", "lowercase-keyword");
    }

    @Test
    public void projectingEmbeddedIdByPropertyName() {
        this.projectionTestHelper("embedded.id", 2L);
    }

    @Test
    public void projectingEmbeddedIdOnOverloadedMapping() {
        this.projectionTestHelper("embedded.stringTypedId", 2L);
    }

    @Test
    public void projectingEmbeddedWithCustomBridge() {
        this.projectionTestHelper("embedded.customBridgedKeyword", "another-lowercase-keyword");
    }

    @Test
    public void projectingEmbeddedWithCustomOneWayBridge() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000324");
        this.thrown.expectMessage("embedded.customOneWayBridgedKeyword");
        this.thrown.expectMessage(CustomOneWayBridge.class.getName());
        this.projectionTestHelper("embedded.customOneWayBridgedKeyword", "another-lowercase-keyword");
    }

    @Test
    public void projectingEmbeddedWithCustomBridgeOverridingMetadata() {
        this.projectionTestHelper("embedded.customTwoWayBridgedKeywordWithMetadataOverride", "another-lowercase-keyword");
    }

    @Test
    public void projectingNotIncludedEmbeddedField() {
        this.projectionTestHelper("embedded.someInteger", null);
    }

    @Test
    public void projectingOnConflictingMappingEmbeddedField() {
        this.projectionTestHelper("second.customBridgedKeyword", 17L);
    }

    @Test
    public void projectingOnConflictingMappedIdField() {
        this.projectionTestHelper("second.id", "a string");
    }

    @Test
    public void concurrentMixedProjections() throws Exception {
        new ConcurrentRunner(1000, 20, new ConcurrentRunner.TaskFactory(){

            @Override
            public Runnable createRunnable(int i) throws Exception {
                return new Runnable(){

                    @Override
                    public void run() {
                        ProjectionConversionTest.this.projectingExplicitId();
                        ProjectionConversionTest.this.projectingIdOnOverloadedMapping();
                        ProjectionConversionTest.this.projectingIntegerField();
                        ProjectionConversionTest.this.projectingUnknownField();
                        ProjectionConversionTest.this.projectionWithCustomBridge();
                        ProjectionConversionTest.this.projectingEmbeddedIdByPropertyName();
                        ProjectionConversionTest.this.projectingEmbeddedIdOnOverloadedMapping();
                        ProjectionConversionTest.this.projectingEmbeddedWithCustomBridge();
                        ProjectionConversionTest.this.projectingOnConflictingMappingEmbeddedField();
                        ProjectionConversionTest.this.projectingOnConflictingMappedIdField();
                    }
                };
            }
        }).execute();
    }

    void projectionTestHelper(String projectionField, Object expectedValue) {
        this.helper.assertThat().from(ExampleEntity.class).projecting(projectionField).matchesExactlySingleProjections(expectedValue);
    }

    public static class CustomTwoWayBridgeOverridingDefaultFieldMetadata
    implements TwoWayFieldBridge,
    MetadataProvidingFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name + ".value", String.valueOf(value).toUpperCase(Locale.ENGLISH), document);
        }

        public Object get(String name, Document document) {
            IndexableField field = document.getField(name + ".value");
            String stringValue = field.stringValue();
            return stringValue.toLowerCase(Locale.ENGLISH);
        }

        public String objectToString(Object object) {
            return String.valueOf(object);
        }

        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(name, FieldType.OBJECT);
            builder.field(name + ".value", FieldType.STRING);
        }
    }

    public static class CustomOneWayBridge
    implements org.hibernate.search.bridge.FieldBridge,
    StringBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, String.valueOf(value).toUpperCase(Locale.ENGLISH), document);
        }

        public String objectToString(Object object) {
            return String.valueOf(object);
        }
    }

    public static class CustomTwoWayBridge
    implements TwoWayFieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, String.valueOf(value).toUpperCase(Locale.ENGLISH), document);
        }

        public Object get(String name, Document document) {
            IndexableField field = document.getField(name);
            String stringValue = field.stringValue();
            return stringValue.toLowerCase(Locale.ENGLISH);
        }

        public String objectToString(Object object) {
            return String.valueOf(object);
        }
    }

    @Indexed
    public static class ConflictingMappedType {
        @DocumentId
        String id;
        @Field(store=Store.YES)
        Long customBridgedKeyword;
    }

    @Indexed
    public static class ExampleEntity {
        @DocumentId
        @Field(name="stringTypedId", store=Store.YES)
        Long id;
        @Field(store=Store.YES)
        Integer someInteger;
        @Field(store=Store.YES)
        @FieldBridge(impl=LongBridge.class)
        Long longEncodedAsText;
        @Field(store=Store.NO)
        String unstoredField;
        @Field(store=Store.YES)
        @FieldBridge(impl=CustomTwoWayBridge.class)
        String customBridgedKeyword;
        @Field(store=Store.YES)
        @FieldBridge(impl=CustomOneWayBridge.class)
        String customOneWayBridgedKeyword;
        @Field(store=Store.YES)
        @FieldBridge(impl=CustomTwoWayBridgeOverridingDefaultFieldMetadata.class)
        String customTwoWayBridgedKeywordWithMetadataOverride;
        @IndexedEmbedded(includePaths={"id", "stringTypedId", "customBridgedKeyword", "customOneWayBridgedKeyword", "customTwoWayBridgedKeywordWithMetadataOverride"}, includeEmbeddedObjectId=true)
        ExampleEntity embedded;
        @IndexedEmbedded(includeEmbeddedObjectId=true)
        ConflictingMappedType second;
    }
}

