/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sorting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.SortableFields;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.bridge.builtin.IntegerBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

public class SortingTest {
    private static final String SORT_TYPE_ERROR_CODE = "HSEARCH000307";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    @Rule
    public final SearchFactoryHolder factoryHolder = new SearchFactoryHolder(Person.class, UnsortableToy.class);
    private final SearchITHelper helper = new SearchITHelper(this.factoryHolder);

    @Test
    public void testSortingOnNumericInt() {
        this.helper.index(new Person(0, (Integer)3, "Three", new Integer[0]), new Person(1, (Integer)10, "Ten", new Integer[0]), new Person(2, (Integer)9, "Nine", new Integer[0]), new Person(3, (Integer)5, "Five", new Integer[0]));
        Sort sortAsString = new Sort(new SortField("ageForStringSorting", SortField.Type.STRING));
        this.assertSortedResults(sortAsString, 1, 0, 3, 2);
        sortAsString = new Sort(new SortField("ageForStringSorting", SortField.Type.STRING, true));
        this.assertSortedResults(sortAsString, 2, 3, 0, 1);
        Sort sortAsInt = new Sort(new SortField("ageForIntSorting", SortField.Type.INT));
        this.assertSortedResults(sortAsInt, 0, 3, 2, 1);
        sortAsInt = new Sort(new SortField("ageForIntSorting", SortField.Type.INT, true));
        this.assertSortedResults(sortAsInt, 1, 2, 3, 0);
    }

    @Test
    public void testSortingOnString() {
        this.helper.index(new Person(0, (Integer)3, "Three", new Integer[0]), new Person(1, (Integer)10, "Ten", new Integer[0]), new Person(2, (Integer)9, "Nine", new Integer[0]), new Person(3, (Integer)5, "Five", new Integer[0]));
        Sort sortAsString = new Sort(new SortField("name", SortField.Type.STRING));
        this.assertSortedResults(sortAsString, 3, 2, 1, 0);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2376")
    public void testSortingOnCollatedString() {
        this.helper.index(new Person(0, (Integer)3, "\u00c9l\u00e9onore", new Integer[0]), new Person(1, (Integer)10, "\u00e9douard", new Integer[0]), new Person(2, (Integer)9, "Edric", new Integer[0]), new Person(3, (Integer)5, "aaron", new Integer[0]), new Person(4, (Integer)7, " zach", new Integer[0]));
        Sort sortAsString = new Sort(new SortField("collatedName", SortField.Type.STRING));
        this.assertSortedResults(sortAsString, 4, 3, 1, 2, 0);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2376")
    public void testAnalyzedSortableStoredField() {
        Person person = new Person(0, (Integer)3, "\u00c9l\u00e9onore", new Integer[0]);
        this.helper.index(person);
        Query query = this.factoryHolder.getSearchFactory().buildQueryBuilder().forEntity(Person.class).get().keyword().onField("id").matching((Object)person.id).createQuery();
        this.assertStoredValueEquals(query, "collatedName", person.name);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2376")
    @Category(value={SkipOnElasticsearch.class})
    public void testSortingOnTokenizedString() {
        this.helper.index(new Person(0, (Integer)3, "elizabeth", new Integer[0]), new Person(1, (Integer)10, "zach other", new Integer[0]), new Person(2, (Integer)9, " edric", new Integer[0]), new Person(3, (Integer)5, "bob", new Integer[0]), new Person(4, (Integer)10, "zach Aaron", new Integer[0]));
        Sort sortAsString = new Sort(new SortField[]{new SortField("tokenizedName", SortField.Type.STRING), SortField.FIELD_DOC});
        this.assertSortedResults(sortAsString, 3, 2, 0, 1, 4);
    }

    @Test
    public void testSortingOnEmbeddedString() {
        this.helper.index(new Person(0, (Integer)3, "Three", new CuddlyToy("Hippo")), new Person(1, (Integer)10, "Ten", new CuddlyToy("Giraffe")), new Person(2, (Integer)9, "Nine", new CuddlyToy("Gorilla")), new Person(3, (Integer)5, "Five", new CuddlyToy("Alligator")));
        Sort sortAsString = new Sort(new SortField("favoriteCuddlyToy.type", SortField.Type.STRING));
        this.assertSortedResults(sortAsString, 3, 1, 2, 0);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2000")
    public void testSortingForTypeWithSortableFieldWithinEmbeddedToManyAssociation() {
        this.helper.index(new Person(0, (Integer)3, "Three", Arrays.asList(new Friend(new CuddlyToy("Hippo")), new Friend(new CuddlyToy("Giraffe")))), new Person(1, (Integer)10, "Ten", Arrays.asList(new Friend(new CuddlyToy("Gorilla")), new Friend(new CuddlyToy("Alligator")))));
        Sort sortAsString = new Sort(new SortField("ageForStringSorting", SortField.Type.STRING));
        this.assertSortedResults(sortAsString, 1, 0);
    }

    @Test
    public void testSortOnNullableNumericField() throws Exception {
        this.helper.index(new Person(1, (Integer)25, "name1", new Integer[0]), new Person(2, (Integer)22, null, new Integer[0]), new Person(3, null, "name3", new Integer[0]));
        HSQuery nameQuery = this.queryForValueNullAndSorting("name", SortField.Type.STRING);
        this.helper.assertThat(nameQuery).hasResultSize(1);
        HSQuery ageQuery = this.queryForValueNullAndSorting("ageForNullChecks", SortField.Type.INT);
        this.helper.assertThat(ageQuery).hasResultSize(1);
    }

    @Test
    public void testExceptionSortingStringFieldAsNumeric() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(SORT_TYPE_ERROR_CODE);
        this.helper.index(new UnsortableToy("111", "Teddy Bear", 300L, 555));
        Class<UnsortableToy> entityType = UnsortableToy.class;
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(entityType).get();
        Query query = queryBuilder.keyword().onField("description").matching((Object)"Teddy Bear").createQuery();
        Sort sort = new Sort(new SortField("description", SortField.Type.DOUBLE));
        HSQuery hsQuery = integrator.createHSQuery(query, new Class[]{entityType});
        hsQuery.sort(sort);
        hsQuery.queryEntityInfos().size();
    }

    @Test
    public void testExceptionSortingNumericFieldWithStringType() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(SORT_TYPE_ERROR_CODE);
        this.helper.index(new UnsortableToy("111", "Teddy Bear", 300L, 555));
        Class<UnsortableToy> entityType = UnsortableToy.class;
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(entityType).get();
        Query query = queryBuilder.keyword().onField("description").matching((Object)"Teddy Bear").createQuery();
        Sort sort = new Sort(new SortField("longValue", SortField.Type.STRING));
        HSQuery hsQuery = integrator.createHSQuery(query, new Class[]{entityType});
        hsQuery.sort(sort);
        hsQuery.queryEntityInfos().size();
    }

    @Test
    public void testExceptionSortingNumericFieldWithWrongType() throws Exception {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage(SORT_TYPE_ERROR_CODE);
        this.helper.index(new UnsortableToy("111", "Teddy Bear", 300L, 555));
        Class<UnsortableToy> entityType = UnsortableToy.class;
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(entityType).get();
        Query query = queryBuilder.keyword().onField("description").matching((Object)"Teddy Bear").createQuery();
        Sort sort = new Sort(new SortField("longValue", SortField.Type.INT));
        HSQuery hsQuery = integrator.createHSQuery(query, new Class[]{entityType});
        hsQuery.sort(sort);
        hsQuery.queryEntityInfos().size();
    }

    @Test
    public void testSortOnNullableNumericFieldArray() throws Exception {
        this.helper.index(new Person(1, (Integer)25, "name1", 1, 2, 3), new Person(2, (Integer)22, "name2", 1, null, 3), new Person(3, (Integer)23, "name3", null, null, null));
        Query rangeQuery = this.queryForRangeOnFieldSorted(0, 2, "array");
        Sort sortAsInt = new Sort(new SortField("array", SortField.Type.INT));
        this.helper.assertThat(rangeQuery).from(Person.class).sort(sortAsInt).hasResultSize(2);
    }

    private Query queryForRangeOnFieldSorted(int min, int max, String fieldName) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Person.class).get();
        return queryBuilder.range().onField(fieldName).from((Object)min).to((Object)max).createQuery();
    }

    private void assertSortedResults(Sort sort, int ... expectedIds) {
        this.helper.assertThat().from(Person.class).sort(sort).matchesExactlyIds(expectedIds);
    }

    private void assertStoredValueEquals(Query query, String fieldName, Object expectedValue) {
        this.helper.assertThat(query).from(Person.class).projecting(fieldName).matchesExactlySingleProjections(expectedValue);
    }

    private HSQuery queryForValueNullAndSorting(String fieldName, SortField.Type sortType) {
        ExtendedSearchIntegrator integrator = this.factoryHolder.getSearchFactory();
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Person.class).get();
        Query query = queryBuilder.keyword().onField(fieldName).matching(null).createQuery();
        HSQuery hsQuery = integrator.createHSQuery(query, new Class[]{Person.class});
        Sort sort = new Sort(new SortField(fieldName, sortType));
        hsQuery.sort(sort);
        return hsQuery;
    }

    @Indexed
    private class UnsortableToy {
        @DocumentId
        String id;
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO)
        String description;
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO)
        Long longValue;
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO)
        Integer integerValue;

        public UnsortableToy(String id, String description, Long longValue, Integer integerValue) {
            this.id = id;
            this.description = description;
            this.longValue = longValue;
            this.integerValue = integerValue;
        }
    }

    private class CuddlyToy {
        @SortableField
        @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
        String type;

        public CuddlyToy(String type) {
            this.type = type;
        }
    }

    private static class Friend {
        @IndexedEmbedded
        final CuddlyToy favoriteCuddlyToy;

        public Friend(CuddlyToy favoriteCuddlyToy) {
            this.favoriteCuddlyToy = favoriteCuddlyToy;
        }
    }

    @NormalizerDef(name="org_hibernate_search_test_sorting_SortingTest_Person_collatingNormalizer", filters={@TokenFilterDef(factory=ASCIIFoldingFilterFactory.class), @TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    @AnalyzerDef(name="org_hibernate_search_test_sorting_SortingTest_Person_tokenizingAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class))
    @Indexed
    private class Person {
        public static final String COLLATING_NORMALIZER_NAME = "org_hibernate_search_test_sorting_SortingTest_Person_collatingNormalizer";
        public static final String TOKENIZING_ANALYZER_NAME = "org_hibernate_search_test_sorting_SortingTest_Person_tokenizingAnalyzer";
        @DocumentId
        final int id;
        @SortableFields(value={@SortableField(forField="ageForStringSorting"), @SortableField(forField="ageForIntSorting"), @SortableField(forField="ageForNullChecks")})
        @Fields(value={@Field(name="ageForStringSorting", store=Store.YES, analyze=Analyze.NO, bridge=@FieldBridge(impl=IntegerBridge.class)), @Field(name="ageForIntSorting", store=Store.YES, analyze=Analyze.NO), @Field(name="ageForNullChecks", store=Store.YES, analyze=Analyze.NO, indexNullAs="-1")})
        final Integer age;
        @SortableFields(value={@SortableField(forField="name"), @SortableField(forField="collatedName"), @SortableField(forField="tokenizedName")})
        @Fields(value={@Field(name="name", store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__"), @Field(name="collatedName", store=Store.YES, normalizer=@Normalizer(definition="org_hibernate_search_test_sorting_SortingTest_Person_collatingNormalizer")), @Field(name="tokenizedName", store=Store.YES, analyzer=@Analyzer(definition="org_hibernate_search_test_sorting_SortingTest_Person_tokenizingAnalyzer"))})
        final String name;
        @IndexedEmbedded
        final CuddlyToy favoriteCuddlyToy;
        @IndexedEmbedded
        final List<Friend> friends;
        @Field
        @SortableField
        @IndexedEmbedded
        Integer[] array;

        Person(int id, Integer age, String name, CuddlyToy favoriteCuddlyToy) {
            this.id = id;
            this.age = age;
            this.name = name;
            this.favoriteCuddlyToy = favoriteCuddlyToy;
            this.friends = new ArrayList<Friend>();
        }

        Person(int id, Integer age, String name, List<Friend> friends) {
            this.id = id;
            this.age = age;
            this.name = name;
            this.favoriteCuddlyToy = null;
            this.friends = friends;
        }

        Person(int id, Integer age, String name, Integer ... arrayItems) {
            this.id = id;
            this.age = age;
            this.name = name;
            this.array = arrayItems;
            this.favoriteCuddlyToy = null;
            this.friends = new ArrayList<Friend>();
        }
    }
}

