/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.hibernate.search.util.impl.Closer;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CloserTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void javaIOCloseable() throws IOException {
        final IOException exception1 = new IOException();
        IllegalStateException exception2 = new IllegalStateException();
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                throw exception1;
            }
        };
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).build());
        try (Closer closer = new Closer();){
            closer.push(closeable::close);
            closer.push(() -> {
                throw exception2;
            });
        }
    }

    @Test
    public void autoCloseable() throws Exception {
        final Exception exception1 = new Exception();
        IllegalStateException exception2 = new IllegalStateException();
        AutoCloseable closeable = new AutoCloseable(){

            @Override
            public void close() throws Exception {
                throw exception1;
            }
        };
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).build());
        try (Closer closer = new Closer();){
            closer.push(closeable::close);
            closer.push(() -> {
                throw exception2;
            });
        }
    }

    @Test
    public void runtimeException() {
        RuntimeException exception1 = new RuntimeException();
        IllegalStateException exception2 = new IllegalStateException();
        UnsupportedOperationException exception3 = new UnsupportedOperationException();
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).withSuppressed(exception3).build());
        try (Closer closer = new Closer();){
            closer.push(() -> {
                throw exception1;
            });
            closer.push(() -> {
                throw exception2;
            });
            closer.push(() -> {
                throw exception3;
            });
        }
    }

    @Test
    public void nonFailingCloseables() {
        RuntimeException exception1 = new RuntimeException();
        RuntimeException exception2 = new RuntimeException();
        RuntimeException exception3 = new RuntimeException();
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).withSuppressed(exception3).build());
        try (Closer closer = new Closer();){
            closer.push(() -> {});
            closer.push(() -> {
                throw exception1;
            });
            closer.push(() -> {
                throw exception2;
            });
            closer.push(() -> {});
            closer.push(() -> {
                throw exception3;
            });
            closer.push(() -> {});
        }
    }

    @Test
    public void customCloseable() throws MyException1 {
        final MyException1 exception1 = new MyException1();
        IllegalStateException exception2 = new IllegalStateException();
        MyException1Closeable closeable = new MyException1Closeable(){

            @Override
            public void close() throws MyException1 {
                throw exception1;
            }
        };
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).build());
        try (Closer closer = new Closer();){
            closer.push(closeable::close);
            closer.push(() -> {
                throw exception2;
            });
        }
    }

    @Test
    public void iterable() throws IOException {
        IOException exception1 = new IOException();
        IllegalStateException exception2 = new IllegalStateException();
        IOException exception3 = new IOException();
        UnsupportedOperationException exception4 = new UnsupportedOperationException();
        List<Closeable> closeables = Arrays.asList(() -> {
            throw exception1;
        }, () -> {
            throw exception2;
        }, () -> {
            throw exception3;
        }, () -> {
            throw exception4;
        });
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).withSuppressed(exception3).withSuppressed(exception4).build());
        try (Closer closer = new Closer();){
            closer.pushAll(Closeable::close, closeables);
        }
    }

    @Test
    public void split() throws IOException, MyException1, MyException2 {
        MyException2 exception1 = new MyException2();
        MyException1 exception2 = new MyException1();
        IOException exception3 = new IOException();
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).withSuppressed(exception3).build());
        try (Closer closer1 = new Closer();
             Closer closer2 = closer1.split();
             Closer closer3 = closer1.split();){
            closer3.push(() -> {
                throw exception1;
            });
            closer2.push(() -> {
                throw exception2;
            });
            closer1.push(() -> {
                throw exception3;
            });
        }
    }

    @Test
    public void split_transitive() throws IOException, MyException1, MyException2 {
        MyException2 exception1 = new MyException2();
        MyException1 exception2 = new MyException1();
        IOException exception3 = new IOException();
        this.thrown.expect(ExceptionMatcherBuilder.isException(exception1).withSuppressed(exception2).withSuppressed(exception3).build());
        try (Closer closer1 = new Closer();
             Closer closer2 = closer1.split();
             Closer closer3 = closer2.split();){
            closer3.push(() -> {
                throw exception1;
            });
            closer2.push(() -> {
                throw exception2;
            });
            closer1.push(() -> {
                throw exception3;
            });
        }
    }

    private static class MyException2
    extends Exception {
        private MyException2() {
        }
    }

    private static interface MyException1Closeable
    extends AutoCloseable {
        @Override
        public void close() throws MyException1;
    }

    private static class MyException1
    extends Exception {
        private MyException1() {
        }
    }
}

