/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.junit.rules.ExternalResource;

public class SearchIntegratorResource
extends ExternalResource {
    private final List<SearchIntegrator> searchIntegrators = new ArrayList<SearchIntegrator>();

    public ExtendedSearchIntegrator create(SearchConfiguration configuration) {
        SearchIntegrator integrator = new SearchIntegratorBuilder().configuration(configuration).buildSearchIntegrator();
        this.searchIntegrators.add(integrator);
        return (ExtendedSearchIntegrator)integrator.unwrap(ExtendedSearchIntegrator.class);
    }

    public ExtendedSearchIntegrator create(SearchIntegrator current, Class<?> ... addedClasses) {
        SearchIntegratorBuilder builder = new SearchIntegratorBuilder().currentSearchIntegrator(current);
        for (Class<?> clazz : addedClasses) {
            builder.addClass(clazz);
        }
        SearchIntegrator integrator = builder.buildSearchIntegrator();
        this.searchIntegrators.add(integrator);
        this.searchIntegrators.remove(current);
        return (ExtendedSearchIntegrator)integrator.unwrap(ExtendedSearchIntegrator.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        Collections.reverse(this.searchIntegrators);
        RuntimeException exception = null;
        try {
            for (SearchIntegrator sf : this.searchIntegrators) {
                try {
                    sf.close();
                }
                catch (RuntimeException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        finally {
            this.searchIntegrators.clear();
        }
    }
}

