/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.testsupport.serialization.SerializationTestHelper;
import org.junit.Assert;
import org.junit.Test;

public class SerializationTestHelperTest {
    @Test
    public void duplicatesAreEqual() throws IOException, ClassNotFoundException {
        Foo a = new Foo();
        a.list.add(new Foo.TestInnerClass(30));
        Foo b = SerializationTestHelper.duplicateBySerialization(a);
        Assert.assertEquals((Object)6, (Object)a.integer);
        Assert.assertEquals((Object)7, (Object)b.integer);
        Assert.assertEquals(a.list, b.list);
    }

    static class Foo
    implements Serializable {
        List<TestInnerClass> list = new ArrayList<TestInnerClass>();
        transient Integer integer = 6;

        Foo() {
        }

        private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
            aInputStream.defaultReadObject();
            this.integer = 7;
        }

        private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
            aOutputStream.defaultWriteObject();
        }

        static class TestInnerClass
        implements Serializable {
            private final int v;

            public TestInnerClass(int i) {
                this.v = i;
            }

            public void print() {
                System.out.println(this.v);
            }

            public String toString() {
                return "" + this.v;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.v;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TestInnerClass other = (TestInnerClass)obj;
                return this.v == other.v;
            }
        }
    }
}

