/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.common;

import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Rule;
import org.junit.Test;

public class CustomAnalyzerDefinitionInClassBridgeTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(FooBar.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testClassBridgeWithSingleField() throws Exception {
        this.helper.index(new FooBar(1));
        TermQuery termQuery = new TermQuery(new Term("classField", "dog"));
        this.helper.assertThat((Query)termQuery).as("custom analyzer should have inserted search token").matchesExactlyIds(Integer.valueOf(1));
    }

    public static class FooBarBridge
    implements FieldBridge {
        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(name, "alarm Dog performance", document);
        }
    }

    @Indexed
    @AnalyzerDef(name="foobarAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    @ClassBridge(name="classField", impl=FooBarBridge.class, analyzer=@Analyzer(definition="foobarAnalyzer"))
    public static class FooBar {
        @DocumentId
        private Integer id;

        public FooBar(Integer id) {
            this.id = id;
        }
    }
}

