/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend.lucene;

import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.impl.CommitPolicy;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.backend.impl.lucene.ScheduledCommitPolicy;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.backend.lucene.Quote;
import org.hibernate.search.testsupport.concurrency.Poller;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.CountingErrorHandler;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
@Category(value={SkipOnElasticsearch.class})
public class ScheduledCommitPolicyTest {
    private static final int NUMBER_ENTITIES = 1000;
    private static final Poller POLLER = Poller.milliseconds(50000L, 20L);
    private int globalIdCounter = 0;
    @Rule
    public final SearchFactoryHolder sfAsyncExclusiveIndex = new SearchFactoryHolder(Quote.class).withProperty("hibernate.search.default.index_flush_interval", "1").withProperty("hibernate.search.default.worker.execution", "async").withProperty("hibernate.search.default.exclusive_index_use", "true").withProperty("hibernate.search.error_handler", CountingErrorHandler.class.getName());
    private final SearchITHelper helper = new SearchITHelper(this.sfAsyncExclusiveIndex);
    private final IndexedTypeIdentifier testType = PojoIndexedTypeIdentifier.convertFromLegacy(Quote.class);

    @Test
    public void testScheduledCommits() throws Exception {
        this.writeData(1000);
        AbstractWorkspaceImpl workspace = this.sfAsyncExclusiveIndex.extractWorkspace(this.testType);
        CommitPolicy commitPolicy = workspace.getCommitPolicy();
        Assert.assertTrue((boolean)(commitPolicy instanceof ScheduledCommitPolicy));
        ScheduledCommitPolicy scheduledCommitPolicy = (ScheduledCommitPolicy)commitPolicy;
        ScheduledThreadPoolExecutor scheduledExecutor = (ScheduledThreadPoolExecutor)scheduledCommitPolicy.getScheduledExecutorService();
        POLLER.pollAssertion(() -> this.assertTaskExecuted(scheduledExecutor, 1));
    }

    @Test
    @BMRule(targetClass="org.apache.lucene.index.IndexWriter", targetMethod="commit", action="throw new IOException(\"File not found!\")", name="commitError")
    public void testErrorHandlingDuringCommit() throws Exception {
        this.writeData(2);
        CountingErrorHandler errorHandler = (CountingErrorHandler)this.sfAsyncExclusiveIndex.getSearchFactory().getErrorHandler();
        POLLER.pollAssertion(() -> Assert.assertTrue((errorHandler.getCountFor(IOException.class) >= 2 ? 1 : 0) != 0));
    }

    @Test
    @BMRule(targetClass="org.hibernate.search.backend.impl.lucene.IndexWriterHolder", targetMethod="commitIndexWriter()", action="throw new NullPointerException(\"Fake internal error\")", name="timerDisruptingError")
    public void testErrorHandlingOnBackgroundThread() throws Exception {
        this.writeData(2);
        CountingErrorHandler errorHandler = (CountingErrorHandler)this.sfAsyncExclusiveIndex.getSearchFactory().getErrorHandler();
        POLLER.pollAssertion(() -> Assert.assertTrue((errorHandler.getCountFor(NullPointerException.class) >= 4 ? 1 : 0) != 0));
    }

    @Test
    public void testDocVisibility() throws Exception {
        this.writeData(1000);
        POLLER.pollAssertion(() -> this.assertIndexingFinished(this.sfAsyncExclusiveIndex, 1000));
        this.writeData(10);
        POLLER.pollAssertion(() -> this.assertIndexingFinished(this.sfAsyncExclusiveIndex, 1010));
        this.writeData(1);
        POLLER.pollAssertion(() -> this.assertIndexingFinished(this.sfAsyncExclusiveIndex, 1011));
    }

    private void assertIndexingFinished(SearchFactoryHolder searchFactoryHolder, int expectedDocsCount) {
        HSQuery query = searchFactoryHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{Quote.class});
        Assert.assertEquals((long)expectedDocsCount, (long)query.queryResultSize());
    }

    private void assertTaskExecuted(ScheduledThreadPoolExecutor executor, int taskCount) {
        Assert.assertTrue((executor.getCompletedTaskCount() >= (long)taskCount ? 1 : 0) != 0);
    }

    private void writeData(int numberEntities) {
        for (int i = 0; i < numberEntities; ++i) {
            Integer id = this.globalIdCounter++;
            Quote quote = new Quote(id, "description");
            this.helper.add(quote);
        }
    }
}

