/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.SpatialMode;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;

@Indexed
class POIHash {
    @DocumentId
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    String type;
    double latitude;
    double longitude;

    @Spatial(spatialMode=SpatialMode.HASH)
    public Coordinates getLocation() {
        return new Coordinates(){

            public Double getLatitude() {
                return POIHash.this.latitude;
            }

            public Double getLongitude() {
                return POIHash.this.longitude;
            }
        };
    }

    public POIHash(Integer id, String name, double latitude, double longitude, String type) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.type = type;
    }

    public POIHash() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getType() {
        return this.type;
    }
}

