/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdefinitionprovider;

import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceCharFilterFactory;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionRegistryBuilder;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalysisDefinitionSourceService;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.indexes.spi.LuceneEmbeddedIndexManagerType;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SkipOnElasticsearch.class})
@TestForIssue(jiraKey="HSEARCH-2418")
public class LuceneAnalysisDefinitionProviderTest {
    private static final String CUSTOM_ANALYZER_NAME = "custom-analyzer";
    private static final String CUSTOM_ANALYZER_2_NAME = "custom-analyzer-2";
    private static final String CUSTOM_NORMALIZER_NAME = "custom-normalizer";
    private static final String CUSTOM_NORMALIZER_2_NAME = "custom-normalizer-2";
    @Rule
    public final SearchIntegratorResource integratorResource = new SearchIntegratorResource();
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private ExtendedSearchIntegrator integrator;
    private final SearchITHelper helper = new SearchITHelper(() -> this.integrator);

    @Test
    public void simple() {
        this.integrator = this.init(CustomAnalyzerProvider.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_NAME)).as("Normalizer reference for 'custom-normalizer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.helper.add(entity);
        this.helper.assertThat("field", "charfilterdidreplace").matchesExactlyIds(Long.valueOf(entity.id));
        this.helper.assertThat("normalized", "charfilterdidreplace|foo").matchesExactlyIds(Long.valueOf(entity.id));
    }

    @Test
    public void usingServiceOverride() {
        this.integrator = this.initUsingService(new CustomAnalyzerProvider(), CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_NAME)).as("Normalizer reference for 'custom-normalizer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.helper.add(entity);
        this.helper.assertThat("field", "charfilterdidreplace").matchesExactlyIds(Long.valueOf(entity.id));
        this.helper.assertThat("normalized", "charfilterdidreplace|foo").matchesExactlyIds(Long.valueOf(entity.id));
    }

    @Test
    public void override() {
        this.integrator = this.init(CustomAnalyzerProvider.class, AnalyzerDefAnnotationEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_NAME)).as("Normalizer reference for 'custom-normalizer' fetched from the integrator")).isNotNull();
        AnalyzerDefAnnotationEntity entity = new AnalyzerDefAnnotationEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.helper.add(entity);
        this.helper.assertThat("field", "charFilterShouldReplace|foo").matchesExactlyIds(Long.valueOf(entity.id));
        this.helper.assertThat("normalized", "charfiltershouldreplace|foo").matchesExactlyIds(Long.valueOf(entity.id));
    }

    @Test
    public void unreferencedAnalyzer() {
        this.integrator = this.init(CustomAnalyzerProvider.class, NoAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getIntegration((IndexManagerType)LuceneEmbeddedIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void instantiation_factorymethod() {
        this.integrator = this.init(ProviderFactory.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)this.integrator.getAnalyzer(CUSTOM_ANALYZER_NAME)).as("Analyzer for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void invalid() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.lucene.analysis_definition_provider", "invalidValue");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000329");
        this.integratorResource.create(cfg);
    }

    @Test
    public void namingConflict_withinProvider_analyzer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000330");
        this.init(ProviderWithInternalAnalyzerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_normalizer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000341");
        this.init(ProviderWithInternalNormalizerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    private ExtendedSearchIntegrator initUsingService(final LuceneAnalysisDefinitionProvider analyzerProvider, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.getProvidedServices().put(LuceneAnalysisDefinitionSourceService.class, new LuceneAnalysisDefinitionSourceService(){

            public LuceneAnalysisDefinitionProvider getLuceneAnalyzerDefinitionProvider() {
                return analyzerProvider;
            }
        });
        return this.integratorResource.create(cfg);
    }

    private ExtendedSearchIntegrator init(Class<?> providerClass, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.addProperty("hibernate.search.lucene.analysis_definition_provider", providerClass.getName());
        return this.integratorResource.create(cfg);
    }

    public static class ProviderWithInternalNormalizerNamingConflict
    implements LuceneAnalysisDefinitionProvider {
        public void register(LuceneAnalysisDefinitionRegistryBuilder builder) {
            builder.normalizer(LuceneAnalysisDefinitionProviderTest.CUSTOM_NORMALIZER_NAME).normalizer(LuceneAnalysisDefinitionProviderTest.CUSTOM_NORMALIZER_NAME);
        }
    }

    public static class ProviderWithInternalAnalyzerNamingConflict
    implements LuceneAnalysisDefinitionProvider {
        public void register(LuceneAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalysisDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(StandardTokenizerFactory.class).analyzer(LuceneAnalysisDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(StandardTokenizerFactory.class);
        }
    }

    public static class CustomAnalyzer2Provider
    implements LuceneAnalysisDefinitionProvider {
        public void register(LuceneAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalysisDefinitionProviderTest.CUSTOM_ANALYZER_2_NAME).tokenizer(WhitespaceTokenizerFactory.class).normalizer(LuceneAnalysisDefinitionProviderTest.CUSTOM_NORMALIZER_2_NAME);
        }
    }

    public static class ProviderFactory {
        @Factory
        public static CustomAnalyzerProvider create() {
            return new CustomAnalyzerProvider();
        }
    }

    public static class CustomAnalyzerProvider
    implements LuceneAnalysisDefinitionProvider {
        public void register(LuceneAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(LuceneAnalysisDefinitionProviderTest.CUSTOM_ANALYZER_NAME).tokenizer(PatternTokenizerFactory.class).param("pattern", "\\|").charFilter(PatternReplaceCharFilterFactory.class).param("pattern", "charFilterShouldReplace").param("replacement", "charFilterDidReplace").tokenFilter(LowerCaseFilterFactory.class).normalizer(LuceneAnalysisDefinitionProviderTest.CUSTOM_NORMALIZER_NAME).charFilter(PatternReplaceCharFilterFactory.class).param("pattern", "charFilterShouldReplace").param("replacement", "charFilterDidReplace").tokenFilter(LowerCaseFilterFactory.class);
        }
    }

    @Indexed
    static class CustomAnalyzer2Entity {
        @DocumentId
        long id;
        @Fields(value={@Field(analyzer=@Analyzer(definition="custom-analyzer-2")), @Field(name="normalized", normalizer=@Normalizer(definition="custom-normalizer-2"))})
        String field;

        CustomAnalyzer2Entity() {
        }
    }

    @Indexed
    @AnalyzerDef(name="custom-analyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class))
    @NormalizerDef(name="custom-normalizer", filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    static class AnalyzerDefAnnotationEntity
    extends CustomAnalyzerEntity {
        AnalyzerDefAnnotationEntity() {
        }
    }

    @Indexed
    static class CustomAnalyzerEntity {
        @DocumentId
        long id;
        @Fields(value={@Field(analyzer=@Analyzer(definition="custom-analyzer")), @Field(name="normalized", normalizer=@Normalizer(definition="custom-normalizer"))})
        String field;

        CustomAnalyzerEntity() {
        }
    }

    @Indexed
    static class NoAnalyzerEntity {
        @DocumentId
        long id;
        @Field(analyze=Analyze.NO)
        String field;

        NoAnalyzerEntity() {
        }
    }
}

