/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.searchfactory;

import java.lang.annotation.ElementType;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMRules;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class SearchFactoryTest {
    @Rule
    public BytemanHelper.BytemanAccessor bytemanAccessor = BytemanHelper.createAccessor();
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void testTypeWithNoDocumentIdThrowsException() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed();
        cfg.setProgrammaticMapping(mapping);
        try {
            this.integratorResource.create(cfg);
            Assert.fail((String)"Invalid configuration should have thrown an exception");
        }
        catch (SearchException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("HSEARCH000177"));
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2277")
    @BMRules(rules={@BMRule(name="Simulate failure on index manager initialization", isInterface=true, targetClass="org.hibernate.search.indexes.spi.IndexManager", targetMethod="initialize(String, Properties, Similarity, WorkerBuildContext)", helper="org.hibernate.search.testsupport.BytemanHelper", action="simulateFailure()"), @BMRule(name="Track calls to ServiceManager.releaseAllServices", targetClass="org.hibernate.search.engine.service.impl.StandardServiceManager", targetMethod="releaseAllServices()", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()")})
    public void testServicesStoppedAfterIndexInitializationException() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addClass(AnnotatedClass.class).addClass(SecondAnnotatedClass.class);
        try {
            this.integratorResource.create(cfg);
            this.failBecauseBytemanRulesDidNotWork();
        }
        catch (SearchException e) {
            Assert.assertEquals((long)1L, (long)this.bytemanAccessor.getAndResetInvocationCount());
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2277")
    @BMRules(rules={@BMRule(name="Skip failure on second index manager initialization", isInterface=true, targetClass="org.hibernate.search.indexes.spi.IndexManager", targetMethod="initialize(String, Properties, Similarity, WorkerBuildContext)", helper="org.hibernate.search.testsupport.BytemanHelper", condition="incrementCounter(\"indexManagerInitialize\") >= 2", action="simulateFailure()"), @BMRule(name="Track calls to IndexManager.destroy", isInterface=true, targetClass="org.hibernate.search.indexes.spi.IndexManager", targetMethod="destroy()", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()")})
    public void testIndexManagerStoppedAfterIndexInitializationException() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addClass(AnnotatedClass.class).addClass(SecondAnnotatedClass.class);
        try {
            this.integratorResource.create(cfg);
            this.failBecauseBytemanRulesDidNotWork();
        }
        catch (SearchException e) {
            Assert.assertEquals((long)1L, (long)this.bytemanAccessor.getAndResetInvocationCount());
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2277")
    @BMRules(rules={@BMRule(name="Simulate failure on index manager search factory setup", targetClass="org.hibernate.search.engine.impl.MutableSearchFactoryState", targetMethod="setActiveSearchIntegrator(ExtendedSearchIntegratorWithShareableState)", helper="org.hibernate.search.testsupport.BytemanHelper", action="simulateFailure()"), @BMRule(name="Track calls to ServiceManager.releaseAllServices", targetClass="org.hibernate.search.engine.service.impl.StandardServiceManager", targetMethod="releaseAllServices()", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()")})
    public void testServicesStoppedAfterIndexManagerSearchFactorySetupException() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addClass(AnnotatedClass.class);
        try {
            this.integratorResource.create(cfg);
            this.failBecauseBytemanRulesDidNotWork();
        }
        catch (BytemanHelper.SimulatedFailureException e) {
            Assert.assertEquals((long)1L, (long)this.bytemanAccessor.getAndResetInvocationCount());
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2277")
    @BMRules(rules={@BMRule(name="Simulate failure on index manager search factory setup", targetClass="org.hibernate.search.engine.impl.MutableSearchFactoryState", targetMethod="setActiveSearchIntegrator(ExtendedSearchIntegratorWithShareableState)", helper="org.hibernate.search.testsupport.BytemanHelper", action="simulateFailure()"), @BMRule(name="Track calls to IndexManager.destroy", isInterface=true, targetClass="org.hibernate.search.indexes.spi.IndexManager", targetMethod="destroy()", helper="org.hibernate.search.testsupport.BytemanHelper", action="countInvocation()")})
    public void testIndexManagerStoppedAfterIndexManagerSearchFactorySetupException() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addClass(AnnotatedClass.class).addClass(SecondAnnotatedClass.class);
        try {
            this.integratorResource.create(cfg);
            this.failBecauseBytemanRulesDidNotWork();
        }
        catch (BytemanHelper.SimulatedFailureException e) {
            Assert.assertEquals((long)2L, (long)this.bytemanAccessor.getAndResetInvocationCount());
        }
    }

    @Test
    public void testGetIndexedTypesNoTypeIndexed() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        ExtendedSearchIntegrator si = this.integratorResource.create(cfg);
        IndexedTypeSet indexedClasses = si.getIndexedTypeIdentifiers();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)0L, (long)indexedClasses.size());
    }

    @Test
    public void testGetIndexedTypeSingleIndexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        ExtendedSearchIntegrator si = this.integratorResource.create(cfg);
        IndexedTypeSet indexedClasses = si.getIndexedTypeIdentifiers();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)1L, (long)indexedClasses.size());
        Assert.assertTrue((boolean)((IndexedTypeIdentifier)indexedClasses.iterator().next()).equals(new PojoIndexedTypeIdentifier(Foo.class)));
    }

    @Test
    public void testGetIndexedTypesMultipleTypes() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId().entity(Bar.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        ExtendedSearchIntegrator si = this.integratorResource.create(cfg);
        IndexedTypeSet indexedClasses = si.getIndexedTypeIdentifiers();
        Assert.assertEquals((String)"Wrong number of indexed entities", (long)2L, (long)indexedClasses.size());
    }

    @Test
    public void testGetTypeDescriptorForUnindexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        ExtendedSearchIntegrator si = this.integratorResource.create(cfg);
        IndexedTypeDescriptor indexedTypeDescriptor = si.getIndexedTypeDescriptor((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(Foo.class));
        Assert.assertNotNull((Object)indexedTypeDescriptor);
        Assert.assertFalse((boolean)indexedTypeDescriptor.isIndexed());
    }

    @Test
    public void testGetTypeDescriptorForIndexedType() {
        SearchConfigurationForTest cfg = this.getManualConfiguration();
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Foo.class).indexed().property("id", ElementType.FIELD).documentId();
        cfg.setProgrammaticMapping(mapping);
        ExtendedSearchIntegrator si = this.integratorResource.create(cfg);
        IndexedTypeDescriptor indexedTypeDescriptor = si.getIndexedTypeDescriptor((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(Foo.class));
        Assert.assertNotNull((Object)indexedTypeDescriptor);
        Assert.assertTrue((boolean)indexedTypeDescriptor.isIndexed());
    }

    private SearchConfigurationForTest getManualConfiguration() {
        return new SearchConfigurationForTest().addClass(Foo.class).addClass(Bar.class);
    }

    private void failBecauseBytemanRulesDidNotWork() {
        Assert.fail((String)"The test could not run because some ByteMan rule did not execute properly.");
    }

    @Indexed
    private static class SecondAnnotatedClass {
        @DocumentId
        private long id;
        @Field
        private String field;

        private SecondAnnotatedClass() {
        }
    }

    @Indexed
    private static class AnnotatedClass {
        @DocumentId
        private long id;
        @Field
        private String field;

        private AnnotatedClass() {
        }
    }

    public static class Bar {
        private long id;
    }

    public static class Foo {
        private long id;
    }
}

