/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.io.InputStream;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.impl.StandardServiceManager;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.util.impl.HibernateSearchResourceLoader;
import org.hibernate.search.util.impl.StreamHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HibernateSearchResourceLoaderTest {
    private HibernateSearchResourceLoader resourceLoader;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        BuildContextForTest buildContext = new BuildContextForTest(searchConfiguration);
        StandardServiceManager serviceManager = new StandardServiceManager((SearchConfiguration)searchConfiguration, (BuildContext)buildContext);
        this.resourceLoader = new HibernateSearchResourceLoader((ServiceManager)serviceManager);
    }

    @Test
    public void testOpenKnownResource() throws Exception {
        String resource = "log4j.properties";
        InputStream in = this.resourceLoader.openResource(resource);
        String resourceContent = StreamHelper.readInputStream((InputStream)in);
        Assert.assertNotNull((Object)resourceContent);
        Assert.assertFalse((boolean)resourceContent.isEmpty());
    }

    @Test
    public void testUnKnownResource() throws Exception {
        String resource = "foo";
        try {
            this.resourceLoader.openResource(resource);
        }
        catch (SearchException e) {
            Assert.assertEquals((String)"Wrong error message", (Object)"HSEARCH000114: Could not load resource: 'foo'", (Object)e.getMessage());
        }
    }
}

