/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.junit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.hibernate.search.util.StringHelper;
import org.junit.Assert;

public class SearchITHelper {
    private final Supplier<? extends SearchIntegrator> integratorProvider;

    public SearchITHelper(SearchFactoryHolder sfHolder) {
        this(sfHolder::getSearchFactory);
    }

    public SearchITHelper(Supplier<? extends SearchIntegrator> integratorProvider) {
        this.integratorProvider = integratorProvider;
    }

    public WorkExecutor executor() {
        return new WorkExecutor();
    }

    public WorkExecutor executor(String tenantId) {
        return new WorkExecutor(tenantId);
    }

    public EntityInstanceWorkContext add() {
        return this.executor().add();
    }

    public void add(Iterable<?> entries) {
        this.add().push(entries).execute();
    }

    public void add(Object ... entries) {
        this.add().push(entries).execute();
    }

    public void add(Object entry, Serializable id) {
        this.add().push(entry, id).execute();
    }

    public EntityInstanceWorkContext index() {
        return this.executor().index();
    }

    public void index(Iterable<?> entries) {
        this.index().push(entries).execute();
    }

    public void index(Object ... entries) {
        this.index().push(entries).execute();
    }

    public void index(Object entry, Serializable id) {
        this.index().push(entry, id).execute();
    }

    public EntityTypeWorkContext delete() {
        return this.executor().delete();
    }

    public void delete(Class<?> type, Iterable<? extends Serializable> ids) {
        this.delete().push(type, ids).execute();
    }

    public void delete(Class<?> type, Serializable ... ids) {
        this.delete().push(type, ids).execute();
    }

    public QueryBuilder queryBuilder(Class<?> clazz) {
        return this.integratorProvider.get().buildQueryBuilder().forEntity(clazz).get();
    }

    public HSQuery hsQuery(Class<?> ... classes) {
        return this.hsQuery((Query)new MatchAllDocsQuery(), classes);
    }

    public HSQuery hsQuery(Query query, Class<?> ... classes) {
        return this.integratorProvider.get().createHSQuery(query, (Class[])classes);
    }

    public AssertBuildingHSQueryContext assertThat(String fieldName, String value) {
        return this.assertThat(SearchITHelper.termQuery(fieldName, value));
    }

    public AssertBuildingHSQueryContext assertThat() {
        return this.assertThat((Query)new MatchAllDocsQuery());
    }

    public AssertBuildingHSQueryContext assertThat(Query luceneQuery) {
        return new AssertBuildingHSQueryContext(luceneQuery);
    }

    public AssertHSQueryContext assertThat(final HSQuery hsQuery) {
        return new AssertHSQueryContext(){

            @Override
            protected HSQuery getHSQuery() {
                return hsQuery;
            }
        };
    }

    private static Query termQuery(String fieldName, String value) {
        return new TermQuery(new Term(fieldName, value));
    }

    public class AssertBuildingHSQueryContext
    extends AssertHSQueryContext {
        private final Query luceneQuery;
        private Class<?>[] classes;
        private Consumer<HSQuery> before;

        private AssertBuildingHSQueryContext(Query luceneQuery) {
            this.before = q -> {};
            this.luceneQuery = luceneQuery;
        }

        public AssertBuildingHSQueryContext from(Class<?> ... classes) {
            this.classes = classes;
            return this;
        }

        public AssertBuildingHSQueryContext sort(Sort sort) {
            this.before = this.before.andThen(q -> q.sort(sort));
            return this;
        }

        public AssertBuildingHSQueryContext projecting(String ... projections) {
            this.before = this.before.andThen(q -> q.projection(projections));
            return this;
        }

        @Override
        protected HSQuery getHSQuery() {
            HSQuery hsQuery = ((SearchIntegrator)SearchITHelper.this.integratorProvider.get()).createHSQuery(this.luceneQuery, (Class[])this.classes);
            this.before.accept(hsQuery);
            return hsQuery;
        }
    }

    public class AssertFacetContext {
        private final AssertHSQueryContext queryContext;
        private final String facetingRequestName;
        private final List<Facet> allFacets;
        private final List<Facet> unmatchedFacets;

        private AssertFacetContext(AssertHSQueryContext queryContext, String facetingRequestName, List<Facet> facets) {
            this.queryContext = queryContext;
            this.facetingRequestName = facetingRequestName;
            this.allFacets = facets;
            this.unmatchedFacets = new ArrayList<Facet>(facets);
        }

        public AssertFacetContext isEmpty() {
            ((ListAssert)Assertions.assertThat(this.allFacets).as("Facets for faceting request '" + this.facetingRequestName + "' on query " + this.queryContext)).isEmpty();
            return this;
        }

        public AssertFacetContext includes(String value, int count) {
            ListIterator<Facet> it = this.unmatchedFacets.listIterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                Facet facet = it.next();
                if (!Objects.equals(value, facet.getValue())) continue;
                ((IntAssert)Assertions.assertThat((int)facet.getCount()).as("Count for faceting request '" + this.facetingRequestName + "', facet '" + value + "' on query " + this.queryContext)).isEqualTo(count);
                it.remove();
                found = true;
            }
            if (!found) {
                Assert.fail((String)("Could not find facet '" + value + "' for faceting request '" + this.facetingRequestName + "' on query " + this.queryContext));
            }
            return this;
        }

        public AssertFacetContext only() {
            ((ListAssert)Assertions.assertThat(this.unmatchedFacets).as("Unexpected facets for faceting request '" + this.facetingRequestName + "' on query " + this.queryContext)).isEmpty();
            return this;
        }
    }

    public abstract class AssertHSQueryContext {
        private String description = null;

        protected abstract HSQuery getHSQuery();

        public AssertHSQueryContext as(String description) {
            this.description = description;
            return this;
        }

        public ListAssert asResultIds() {
            HSQuery hsQuery = this.getHSQuery();
            List results = hsQuery.queryEntityInfos();
            List ids = results.stream().map(EntityInfo::getId).collect(Collectors.toList());
            return (ListAssert)Assertions.assertThat(ids).as("IDs of results of query " + this.toString(hsQuery));
        }

        public ListAssert asResultProjectionsAsLists() {
            HSQuery hsQuery = this.getHSQuery();
            List results = hsQuery.queryEntityInfos();
            List projections = results.stream().map(EntityInfo::getProjection).map(Arrays::asList).collect(Collectors.toList());
            return (ListAssert)Assertions.assertThat(projections).as("Projections of results of query " + this.toString(hsQuery));
        }

        public ListAssert asResults() {
            HSQuery hsQuery = this.getHSQuery();
            List results = hsQuery.queryEntityInfos();
            return (ListAssert)Assertions.assertThat((List)results).as("Results of query " + this.toString(hsQuery));
        }

        public IntAssert asResultSize() {
            HSQuery hsQuery = this.getHSQuery();
            int actualSize = hsQuery.queryResultSize();
            return (IntAssert)Assertions.assertThat((int)actualSize).as("Number of results of query " + this.toString(hsQuery));
        }

        @SafeVarargs
        public final AssertHSQueryContext matchesExactlyIds(Serializable ... expectedIds) {
            Object[] objectArray = Arrays.stream(expectedIds).toArray();
            this.asResultIds().containsExactly(objectArray);
            return this;
        }

        public final AssertHSQueryContext matchesExactlyIds(int[] expectedIds) {
            Object[] objectArray = Arrays.stream(expectedIds).mapToObj(i -> i).toArray();
            this.asResultIds().containsExactly(objectArray);
            return this;
        }

        @SafeVarargs
        public final AssertHSQueryContext matchesUnorderedIds(Serializable ... expectedIds) {
            Object[] objectArray = Arrays.stream(expectedIds).toArray();
            this.asResultIds().containsOnly(objectArray);
            return this;
        }

        public final AssertHSQueryContext matchesUnorderedIds(int[] expectedIds) {
            Object[] objectArray = Arrays.stream(expectedIds).mapToObj(i -> i).toArray();
            this.asResultIds().containsOnly(objectArray);
            return this;
        }

        @SafeVarargs
        public final AssertHSQueryContext matchesExactlyProjections(Object[] ... expectedProjections) {
            Object[] objectArray = Arrays.stream(expectedProjections).map(Arrays::asList).toArray();
            this.asResultProjectionsAsLists().containsExactly(objectArray);
            return this;
        }

        @SafeVarargs
        public final <T> AssertHSQueryContext matchesExactlySingleProjections(T ... expectedSingleElementProjections) {
            Object[] objectArray = Arrays.stream(expectedSingleElementProjections).map(p -> Arrays.asList(p)).toArray();
            this.asResultProjectionsAsLists().containsExactly(objectArray);
            return this;
        }

        @SafeVarargs
        public final AssertHSQueryContext matchesUnorderedProjections(Object[] ... expectedProjections) {
            Object[] objectArray = Arrays.stream(expectedProjections).map(Arrays::asList).toArray();
            this.asResultProjectionsAsLists().containsOnly(objectArray);
            return this;
        }

        @SafeVarargs
        public final <T> AssertHSQueryContext matchesUnorderedSingleProjections(T ... expectedSingleElementProjections) {
            Object[] objectArray = Arrays.stream(expectedSingleElementProjections).map(p -> Arrays.asList(p)).toArray();
            this.asResultProjectionsAsLists().containsOnly(objectArray);
            return this;
        }

        public final <T> AssertHSQueryContext matchesNone() {
            this.asResultIds().isEmpty();
            return this;
        }

        public final <T> AssertHSQueryContext matches() {
            this.asResultIds().isNotEmpty();
            return this;
        }

        public AssertHSQueryContext hasResultSize(int size) {
            this.asResultSize().isEqualTo(size);
            return this;
        }

        public final <T> AssertFacetContext facets(String facetingRequestName) {
            HSQuery hsQuery = this.getHSQuery();
            List facets = hsQuery.getFacetManager().getFacets(facetingRequestName);
            return new AssertFacetContext(this, facetingRequestName, facets);
        }

        private String toString(HSQuery query) {
            StringBuilder builder = new StringBuilder();
            if (StringHelper.isNotEmpty((String)this.description)) {
                builder.append(this.description).append(" - ");
            }
            builder.append("<").append(query.getQueryString()).append(">").append(" from <").append(query.getTargetedEntities()).append(">");
            String[] projected = query.getProjectedFields();
            if (projected != null && projected.length > 0) {
                builder.append(" with projections <").append(query.getProjectedFields()).append(">");
            }
            return builder.toString();
        }
    }

    public class EntityTypeWorkContext {
        private final WorkType workType;
        private WorkExecutor executor;

        private EntityTypeWorkContext(WorkType workType, WorkExecutor executor) {
            this.workType = workType;
            this.executor = executor;
        }

        public EntityTypeWorkContext push(Class<?> type, Serializable ... ids) {
            return this.push(type, Arrays.stream(ids));
        }

        public EntityTypeWorkContext push(Class<?> type, Iterable<? extends Serializable> ids) {
            return this.push(type, StreamSupport.stream(ids.spliterator(), false));
        }

        public EntityTypeWorkContext push(Class<?> type, Stream<? extends Serializable> ids) {
            this.executor.push(ids.map(id -> new Work(this.executor.tenantId, (IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(type), id, this.workType)));
            return this;
        }

        public void execute() {
            this.executor.execute();
        }
    }

    public class EntityInstanceWorkContext {
        private final WorkType workType;
        private WorkExecutor executor;

        private EntityInstanceWorkContext(WorkType workType, WorkExecutor executor) {
            this.workType = workType;
            this.executor = executor;
        }

        public EntityInstanceWorkContext push(Object entry, Serializable id) {
            this.executor.push(new Work(this.executor.tenantId, entry, id, this.workType, false));
            return this;
        }

        public EntityInstanceWorkContext push(Iterable<?> entries) {
            return this.push(StreamSupport.stream(entries.spliterator(), false));
        }

        public EntityInstanceWorkContext push(Object ... entries) {
            return this.push(Arrays.stream(entries));
        }

        public EntityInstanceWorkContext push(Stream<?> entries) {
            this.executor.push(entries.map(e -> new Work(this.executor.tenantId, e, null, this.workType, false)));
            return this;
        }

        public void execute() {
            this.executor.execute();
        }
    }

    public class WorkExecutor {
        private final String tenantId;
        private List<Work> works = new ArrayList<Work>();

        public WorkExecutor() {
            this(null);
        }

        public WorkExecutor(String tenantId) {
            this.tenantId = tenantId;
        }

        public EntityInstanceWorkContext add() {
            return new EntityInstanceWorkContext(WorkType.ADD, this);
        }

        public EntityInstanceWorkContext index() {
            return new EntityInstanceWorkContext(WorkType.INDEX, this);
        }

        public EntityTypeWorkContext delete() {
            return new EntityTypeWorkContext(WorkType.DELETE, this);
        }

        public void push(Work work) {
            this.works.add(work);
        }

        public void push(Stream<? extends Work> works) {
            works.forEach(this.works::add);
        }

        public void execute() {
            TransactionContextForTest tc = new TransactionContextForTest();
            this.works.forEach(w -> ((SearchIntegrator)SearchITHelper.this.integratorProvider.get()).getWorker().performWork(w, (TransactionContext)tc));
            tc.end();
            this.works.clear();
        }
    }

    public static interface Identifiable<T extends Serializable> {
        public T getId();
    }
}

