/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.query.engine.spi.EntityInfo;

public class EntityInfoImpl
implements EntityInfo {
    private final Class<?> clazz;
    private final Serializable id;
    private final String idName;
    private final Object[] projection;
    private Set<Integer> indexesOfThis = Collections.EMPTY_SET;

    @Override
    public void setIndexesOfThis(int x) {
        if (this.indexesOfThis == Collections.EMPTY_SET) {
            this.indexesOfThis = new HashSet<Integer>();
        }
        this.indexesOfThis.add(x);
    }

    @Override
    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    @Override
    public String getIdName() {
        return this.idName;
    }

    @Override
    public Object[] getProjection() {
        return this.projection;
    }

    @Override
    public Iterable<Integer> getIndexesOfThis() {
        return this.indexesOfThis;
    }

    @Override
    public boolean isProjectThis() {
        return this.indexesOfThis.size() != 0;
    }

    @Override
    public void populateWithEntityInstance(Object entity) {
        for (int index : this.indexesOfThis) {
            this.projection[index] = entity;
        }
    }

    public EntityInfoImpl(Class clazz, String idName, Serializable id, Object[] projection) {
        this.clazz = clazz;
        this.idName = idName;
        this.id = id;
        this.projection = projection != null ? (Object[])projection.clone() : null;
    }

    public String toString() {
        return "EntityInfoImpl{idName='" + this.idName + '\'' + ", id=" + this.id + ", clazz=" + this.clazz + '}';
    }
}

