/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Index;
import io.searchbox.indices.Flush;
import io.searchbox.indices.Optimize;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.BridgeAdaptorUtils;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.DefaultBackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.DeleteByQueryResultAssessor;
import org.hibernate.search.elasticsearch.impl.DocumentAddedBackendRequestSuccessReporter;
import org.hibernate.search.elasticsearch.impl.JestAPIFormatter;
import org.hibernate.search.elasticsearch.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.impl.JsonAccessorBuilder;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.JsonElementType;
import org.hibernate.search.elasticsearch.impl.NestingMarker;
import org.hibernate.search.elasticsearch.impl.NoopBackendRequestSuccessHandler;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.impl.UnexpectedJsonElementTypeException;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.FieldHelper;
import org.hibernate.search.elasticsearch.util.impl.ParentPathMismatchException;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchIndexWorkVisitor
implements IndexWorkVisitor<IndexingMonitor, BackendRequest<?>> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final String DELETE_ALL_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"match_all\" : { } } } } }";
    private static final String DELETE_ALL_FOR_TENANT_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"term\" : { \"__HSearch_TenantId\" : \"%s\" } } } } }";
    private final String indexName;
    private final boolean refreshAfterWrite;
    private final ExtendedSearchIntegrator searchIntegrator;
    private final BackendRequestResultAssessor<JestResult> defaultResultAssessor;
    private final BackendRequestResultAssessor<JestResult> deleteResultAssessor;
    private final BackendRequestResultAssessor<JestResult> deleteByQueryResultAssessor;

    public ElasticsearchIndexWorkVisitor(String indexName, boolean refreshAfterWrite, ExtendedSearchIntegrator searchIntegrator, JestAPIFormatter jestApiFormatter) {
        this.indexName = indexName;
        this.refreshAfterWrite = refreshAfterWrite;
        this.searchIntegrator = searchIntegrator;
        this.defaultResultAssessor = DefaultBackendRequestResultAssessor.builder(jestApiFormatter).build();
        this.deleteResultAssessor = DefaultBackendRequestResultAssessor.builder(jestApiFormatter).ignoreErrorStatuses(404).build();
        this.deleteByQueryResultAssessor = new DeleteByQueryResultAssessor(jestApiFormatter);
    }

    public BackendRequest<?> visitAddWork(AddLuceneWork work, IndexingMonitor monitor) {
        Action<DocumentResult> index = this.indexDocument(this.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass());
        return new BackendRequest<DocumentResult>(index, (LuceneWork)work, this.indexName, this.defaultResultAssessor, monitor, DocumentAddedBackendRequestSuccessReporter.INSTANCE, this.refreshAfterWrite);
    }

    public BackendRequest<?> visitDeleteWork(DeleteLuceneWork work, IndexingMonitor monitor) {
        Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(this.getDocumentId((LuceneWork)work)).index(this.indexName)).type(work.getEntityClass().getName())).build();
        return new BackendRequest<JestResult>((Action<JestResult>)delete, (LuceneWork)work, this.indexName, this.deleteResultAssessor, monitor, NoopBackendRequestSuccessHandler.INSTANCE, this.refreshAfterWrite);
    }

    public BackendRequest<?> visitOptimizeWork(OptimizeLuceneWork work, IndexingMonitor monitor) {
        Optimize optimize = ((Optimize.Builder)new Optimize.Builder().addIndex(this.indexName)).build();
        return new BackendRequest<JestResult>((Action<JestResult>)optimize, (LuceneWork)work, this.indexName, this.defaultResultAssessor, monitor, NoopBackendRequestSuccessHandler.INSTANCE, this.refreshAfterWrite);
    }

    public BackendRequest<?> visitPurgeAllWork(PurgeAllLuceneWork work, IndexingMonitor monitor) {
        String query = work.getTenantId() != null ? String.format(Locale.ENGLISH, DELETE_ALL_FOR_TENANT_QUERY, work.getTenantId()) : DELETE_ALL_QUERY;
        DeleteByQuery.Builder builder = (DeleteByQuery.Builder)new DeleteByQuery.Builder(query).addIndex(this.indexName);
        Set typesToDelete = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{work.getEntityClass()});
        for (Class typeToDelete : typesToDelete) {
            builder.addType(typeToDelete.getName());
        }
        return new BackendRequest<JestResult>((Action<JestResult>)builder.build(), (LuceneWork)work, this.indexName, this.deleteByQueryResultAssessor, monitor, NoopBackendRequestSuccessHandler.INSTANCE, this.refreshAfterWrite);
    }

    public BackendRequest<?> visitUpdateWork(UpdateLuceneWork work, IndexingMonitor monitor) {
        Action<DocumentResult> index = this.indexDocument(this.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass());
        return new BackendRequest<DocumentResult>(index, (LuceneWork)work, this.indexName, this.defaultResultAssessor, monitor, DocumentAddedBackendRequestSuccessReporter.INSTANCE, this.refreshAfterWrite);
    }

    public BackendRequest<?> visitFlushWork(FlushLuceneWork work, IndexingMonitor monitor) {
        Flush flush = ((Flush.Builder)((Flush.Builder)((Flush.Builder)new Flush.Builder().setParameter("wait_if_ongoing", (Object)"true")).addIndex(this.indexName)).refresh(true)).build();
        return new BackendRequest<JestResult>((Action<JestResult>)flush, (LuceneWork)work, this.indexName, this.defaultResultAssessor, monitor, NoopBackendRequestSuccessHandler.INSTANCE, false);
    }

    public BackendRequest<?> visitDeleteByQueryWork(DeleteByQueryLuceneWork work, IndexingMonitor monitor) {
        JsonObject convertedQuery = ToElasticsearch.fromDeletionQuery(this.searchIntegrator.getIndexBinding(work.getEntityClass()).getDocumentBuilder(), work.getDeletionQuery());
        String type = work.getEntityClass().getName();
        JsonObject query = work.getTenantId() != null ? JsonBuilder.object().add("query", JsonBuilder.object().add("bool", JsonBuilder.object().add("filter", JsonBuilder.object().add("term", JsonBuilder.object().addProperty("__HSearch_TenantId", work.getTenantId()))).add("must", (JsonElement)convertedQuery))).build() : JsonBuilder.object().add("query", (JsonElement)convertedQuery).build();
        DeleteByQuery deleteByQuery = ((DeleteByQuery.Builder)((DeleteByQuery.Builder)new DeleteByQuery.Builder(query.toString()).addIndex(this.indexName)).addType(type)).build();
        return new BackendRequest<JestResult>((Action<JestResult>)deleteByQuery, (LuceneWork)work, this.indexName, this.deleteByQueryResultAssessor, monitor, NoopBackendRequestSuccessHandler.INSTANCE, this.refreshAfterWrite);
    }

    private Action<DocumentResult> indexDocument(String id, Document document, Class<?> entityType) {
        JsonObject source = this.convertDocumentToJson(document, entityType);
        String type = entityType.getName();
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)source).index(this.indexName)).type(type)).id(id)).build();
        return index;
    }

    private JsonObject convertDocumentToJson(Document document, Class<?> entityType) {
        EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(entityType);
        JsonObject root = new JsonObject();
        NestingMarker nestingMarker = null;
        JsonAccessorBuilder accessorBuilder = new JsonAccessorBuilder();
        for (IndexableField field : document.getFields()) {
            if (field instanceof NestingMarker) {
                nestingMarker = (NestingMarker)field;
                accessorBuilder.reset();
                accessorBuilder.append(((NestingMarker)field).getPath());
                continue;
            }
            this.convertFieldToJson(root, accessorBuilder, indexBinding, nestingMarker, document, field);
        }
        return root;
    }

    private void convertFieldToJson(JsonObject root, JsonAccessorBuilder accessorBuilder, EntityIndexBinding indexBinding, NestingMarker nestingMarker, Document document, IndexableField field) {
        try {
            EmbeddedTypeMetadata embeddedType;
            String fieldPath = field.name();
            List<NestingMarker.NestingPathComponent> nestingPath = nestingMarker == null ? null : nestingMarker.getPath();
            NestingMarker.NestingPathComponent lastPathComponent = nestingPath == null ? null : nestingPath.get(nestingPath.size() - 1);
            EmbeddedTypeMetadata embeddedTypeMetadata = embeddedType = lastPathComponent == null ? null : lastPathComponent.getEmbeddedTypeMetadata();
            if (embeddedType != null && fieldPath.equals(embeddedType.getEmbeddedNullFieldName())) {
                nestingPath = nestingPath.subList(0, nestingPath.size() - 1);
                accessorBuilder.reset();
                accessorBuilder.append(nestingPath);
                EmbeddedTypeMetadata.Container containerType = embeddedType.getEmbeddedContainer();
                switch (containerType) {
                    case ARRAY: 
                    case COLLECTION: 
                    case MAP: {
                        String value = field.stringValue();
                        accessorBuilder.buildForPath(fieldPath).set(root, (JsonElement)(value != null ? new JsonPrimitive(value) : null));
                        break;
                    }
                    case OBJECT: {
                        break;
                    }
                    default: {
                        throw new AssertionFailure("Unexpected container type: " + containerType);
                    }
                }
            } else {
                if ("$facets".equals(field.name())) {
                    return;
                }
                if (this.isDocValueField(field)) {
                    return;
                }
                if (fieldPath.equals("_hibernate_class")) {
                    return;
                }
                DocumentFieldMetadata documentFieldMetadata = indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name());
                if (documentFieldMetadata == null) {
                    if (SpatialHelper.isSpatialField((String)fieldPath)) {
                        if (SpatialHelper.isSpatialFieldLatitude((String)fieldPath)) {
                            Number value = field.numericValue();
                            String spatialPropertyPath = SpatialHelper.stripSpatialFieldSuffix((String)fieldPath);
                            accessorBuilder.buildForPath(spatialPropertyPath + ".lat").add(root, value != null ? new JsonPrimitive(value) : null);
                        } else if (SpatialHelper.isSpatialFieldLongitude((String)fieldPath)) {
                            Number value = field.numericValue();
                            String spatialPropertyPath = SpatialHelper.stripSpatialFieldSuffix((String)fieldPath);
                            accessorBuilder.buildForPath(spatialPropertyPath + ".lon").add(root, value != null ? new JsonPrimitive(value) : null);
                        } else {
                            String value = field.stringValue();
                            accessorBuilder.buildForPath(fieldPath).add(root, value != null ? new JsonPrimitive(value) : null);
                        }
                    } else {
                        JsonAccessor accessor = accessorBuilder.buildForPath(fieldPath);
                        String stringValue = field.stringValue();
                        Number numericValue = field.numericValue();
                        if (stringValue != null) {
                            accessor.add(root, new JsonPrimitive(stringValue));
                        } else if (numericValue != null) {
                            accessor.add(root, new JsonPrimitive(numericValue));
                        } else {
                            accessor.add(root, null);
                        }
                    }
                } else {
                    JsonAccessor accessor = accessorBuilder.buildForPath(fieldPath);
                    if (field instanceof NullMarker) {
                        accessor.add(root, null);
                        return;
                    }
                    FieldHelper.ExtendedFieldType type = FieldHelper.getType(documentFieldMetadata);
                    if (FieldHelper.ExtendedFieldType.BOOLEAN.equals((Object)type)) {
                        FieldBridge fieldBridge = documentFieldMetadata.getFieldBridge();
                        TwoWayStringBridge twoWayStringBridge = (TwoWayStringBridge)BridgeAdaptorUtils.unwrapAdaptorOnly((Object)fieldBridge, TwoWayStringBridge.class);
                        if (twoWayStringBridge == null) {
                            throw LOG.booleanBridgeMustImplementTwoWayStringBridge(indexBinding.getDocumentBuilder().getBeanClass(), accessor.getStaticAbsolutePath());
                        }
                        Boolean value = (Boolean)twoWayStringBridge.stringToObject(field.stringValue());
                        accessor.add(root, value != null ? new JsonPrimitive(value) : null);
                    } else {
                        Number numericValue = field.numericValue();
                        if (numericValue != null) {
                            accessor.add(root, new JsonPrimitive(numericValue));
                        } else {
                            String stringValue = field.stringValue();
                            accessor.add(root, stringValue != null ? new JsonPrimitive(stringValue) : null);
                        }
                    }
                }
            }
        }
        catch (ParentPathMismatchException e) {
            throw LOG.indexedEmbeddedPrefixBypass(indexBinding.getDocumentBuilder().getBeanClass(), e.getMismatchingPath(), e.getExpectedParentPath());
        }
        catch (UnexpectedJsonElementTypeException e) {
            List<JsonElementType<?>> expectedTypes = e.getExpectedTypes();
            JsonAccessor accessor = e.getAccessor();
            JsonElement actualValue = e.getActualElement();
            if (expectedTypes.contains(JsonElementType.OBJECT) || JsonElementType.OBJECT.isInstance(actualValue)) {
                throw LOG.fieldIsBothCompositeAndConcrete(indexBinding.getDocumentBuilder().getBeanClass(), accessor.getStaticAbsolutePath());
            }
            throw new AssertionFailure("Unexpected field naming conflict when indexing; this kind of issue should have been detected when building the metadata.", (Throwable)e);
        }
    }

    private String getDocumentId(LuceneWork work) {
        return work.getTenantId() == null ? work.getIdInString() : work.getTenantId() + "_" + work.getIdInString();
    }

    private boolean isDocValueField(IndexableField field) {
        return field.fieldType().docValuesType() != DocValuesType.NONE;
    }
}

