/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.aliases;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AliasMapping {
    protected List<String> indices = new LinkedList<String>();
    protected String alias;
    protected Map<String, Object> filter;
    protected List<String> searchRouting = new LinkedList<String>();
    protected List<String> indexRouting = new LinkedList<String>();

    public abstract String getType();

    public List<Map<String, Object>> getData() {
        LinkedList<Map<String, Object>> retList = new LinkedList<Map<String, Object>>();
        for (String index : this.indices) {
            LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
            paramsMap.put("index", index);
            paramsMap.put("alias", this.alias);
            if (this.filter != null) {
                paramsMap.put("filter", this.filter);
            }
            if (this.searchRouting.size() > 0) {
                paramsMap.put("search_routing", StringUtils.join(this.searchRouting, (String)","));
            }
            if (this.indexRouting.size() > 0) {
                paramsMap.put("index_routing", StringUtils.join(this.indexRouting, (String)","));
            }
            LinkedHashMap<String, LinkedHashMap<String, Object>> actionMap = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
            actionMap.put(this.getType(), paramsMap);
            retList.add(actionMap);
        }
        return retList;
    }
}

