/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.util.Map;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.hibernate.search.cfg.AnalyzerDefMapping;
import org.hibernate.search.cfg.CharFilterDefMapping;
import org.hibernate.search.cfg.EntityMapping;
import org.hibernate.search.cfg.FullTextFilterDefMapping;
import org.hibernate.search.cfg.SearchMapping;

public class TokenFilterDefMapping {
    private Map<String, Object> filter;
    private Map<String, Object> analyzerDef;
    private SearchMapping mapping;

    TokenFilterDefMapping(Class<? extends TokenFilterFactory> factory, Map<String, Object> analyzerDef, SearchMapping mapping) {
        this.mapping = mapping;
        this.analyzerDef = analyzerDef;
        this.filter = SearchMapping.addElementToAnnotationArray(analyzerDef, "filters");
        this.filter.put("factory", factory);
    }

    public TokenFilterDefMapping param(String name, String value) {
        Map<String, Object> param = SearchMapping.addElementToAnnotationArray(this.filter, "params");
        param.put("name", name);
        param.put("value", value);
        return this;
    }

    public TokenFilterDefMapping filter(Class<? extends TokenFilterFactory> factory) {
        return this.filter("", factory);
    }

    public TokenFilterDefMapping filter(String name, Class<? extends TokenFilterFactory> factory) {
        return new TokenFilterDefMapping(factory, this.analyzerDef, this.mapping);
    }

    public CharFilterDefMapping charFilter(Class<? extends CharFilterFactory> factory) {
        return this.charFilter("", factory);
    }

    public CharFilterDefMapping charFilter(String name, Class<? extends CharFilterFactory> factory) {
        return new CharFilterDefMapping(name, factory, this.analyzerDef, this.mapping);
    }

    public EntityMapping entity(Class<?> entityType) {
        return new EntityMapping(entityType, this.mapping);
    }

    public AnalyzerDefMapping analyzerDef(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
        return this.analyzerDef(name, "", tokenizerFactory);
    }

    public AnalyzerDefMapping analyzerDef(String name, String tokenizerName, Class<? extends TokenizerFactory> tokenizerFactory) {
        return new AnalyzerDefMapping(name, tokenizerName, tokenizerFactory, this.mapping);
    }

    public FullTextFilterDefMapping fullTextFilterDef(String name, Class<?> impl) {
        return new FullTextFilterDefMapping(this.mapping, name, impl);
    }
}

