/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ScopedElasticsearchAnalyzer;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedElasticsearchAnalyzerReference
extends ElasticsearchAnalyzerReference
implements ScopedAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private ScopedElasticsearchAnalyzer analyzer;
    private DeferredInitializationBuilder builder;

    public ScopedElasticsearchAnalyzerReference(ScopedElasticsearchAnalyzer analyzer) {
        this.builder = null;
        this.analyzer = analyzer;
    }

    private ScopedElasticsearchAnalyzerReference(DeferredInitializationBuilder builder) {
        this.builder = builder;
        this.analyzer = null;
    }

    @Override
    public ScopedElasticsearchAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyRemoteAnalyzerReferenceNotInitialized((RemoteAnalyzerReference)this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize() {
        if (this.analyzer != null) {
            throw new AssertionFailure("An Elasticsearch analyzer reference has been initialized more than once: " + (Object)((Object)this));
        }
        this.analyzer = this.builder.buildAnalyzer();
        this.builder = null;
    }

    public void close() {
        if (this.isInitialized()) {
            this.getAnalyzer().close();
        }
    }

    public CopyBuilder startCopy() {
        return new CopyBuilder(this.getAnalyzer());
    }

    private static ElasticsearchAnalyzerReference getElasticsearchAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
            throw LOG.analyzerReferenceIsNotRemote(analyzerReference);
        }
        return (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
    }

    public static class CopyBuilder
    implements ScopedAnalyzerReference.CopyBuilder {
        private final ScopedElasticsearchAnalyzer baseAnalyzer;
        private final Map<String, ElasticsearchAnalyzer> scopedAnalyzersOverrides = new HashMap<String, ElasticsearchAnalyzer>();

        protected CopyBuilder(ScopedElasticsearchAnalyzer baseAnalyzer) {
            this.baseAnalyzer = baseAnalyzer;
        }

        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzersOverrides.put(scope, ScopedElasticsearchAnalyzerReference.getElasticsearchAnalyzerReference(analyzerReference).getAnalyzer());
        }

        public ScopedElasticsearchAnalyzerReference build() {
            ElasticsearchAnalyzer globalAnalyzer = this.baseAnalyzer.getGlobalAnalyzer();
            HashMap<String, ElasticsearchAnalyzer> scopedAnalyzers = new HashMap<String, ElasticsearchAnalyzer>(this.baseAnalyzer.getScopedAnalyzers());
            scopedAnalyzers.putAll(this.scopedAnalyzersOverrides);
            ScopedElasticsearchAnalyzer scopedAnalyzer = new ScopedElasticsearchAnalyzer(globalAnalyzer, scopedAnalyzers);
            return new ScopedElasticsearchAnalyzerReference(scopedAnalyzer);
        }
    }

    public static class DeferredInitializationBuilder
    implements ScopedAnalyzerReference.Builder {
        private ElasticsearchAnalyzerReference globalAnalyzerReference;
        private final Map<String, ElasticsearchAnalyzerReference> scopedAnalyzerReferences = new HashMap<String, ElasticsearchAnalyzerReference>();

        public DeferredInitializationBuilder(ElasticsearchAnalyzerReference globalAnalyzerReference, Map<String, ElasticsearchAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzerReferences.putAll(scopedAnalyzers);
        }

        public ElasticsearchAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedElasticsearchAnalyzerReference.getElasticsearchAnalyzerReference(globalAnalyzerReference);
        }

        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzerReferences.put(scope, ScopedElasticsearchAnalyzerReference.getElasticsearchAnalyzerReference(analyzerReference));
        }

        public ScopedElasticsearchAnalyzerReference build() {
            return new ScopedElasticsearchAnalyzerReference(this);
        }

        protected final ScopedElasticsearchAnalyzer buildAnalyzer() {
            ElasticsearchAnalyzer globalAnalyzer = this.globalAnalyzerReference.getAnalyzer();
            HashMap<String, ElasticsearchAnalyzer> scopedAnalyzers = new HashMap<String, ElasticsearchAnalyzer>();
            for (Map.Entry<String, ElasticsearchAnalyzerReference> entry : this.scopedAnalyzerReferences.entrySet()) {
                scopedAnalyzers.put(entry.getKey(), entry.getValue().getAnalyzer());
            }
            return new ScopedElasticsearchAnalyzer(globalAnalyzer, scopedAnalyzers);
        }
    }
}

