/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.DateTimeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalDateTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchOffsetDateTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<OffsetDateTime> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalDateTimeBridge.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchOffsetDateTimeBridge INSTANCE = new ElasticsearchOffsetDateTimeBridge();

    private ElasticsearchOffsetDateTimeBridge() {
        super(FORMATTER, OffsetDateTime.class);
    }

    @Override
    OffsetDateTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return OffsetDateTime.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForOffsetDateTime(e);
    }
}

