/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.DefaultBackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.impl.JestAPIFormatter;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class JestClient
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final String HTTP_SCHEME = "http";
    private static final String CLIENT_PROP_PREFIX = "hibernate.search.default.";
    private io.searchbox.client.JestClient client;
    private ServiceManager serviceManager;
    private GsonService gsonService;
    private JestAPIFormatter jestAPIFormatter;
    private DefaultBackendRequestResultAssessor defaultResultAssessor;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
        this.jestAPIFormatter = (JestAPIFormatter)this.serviceManager.requestService(JestAPIFormatter.class);
        this.defaultResultAssessor = DefaultBackendRequestResultAssessor.builder(this.jestAPIFormatter).build();
        JestClientFactory factory = new JestClientFactory();
        String serverUrisString = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.default.elasticsearch.host", (String)"http://localhost:9200");
        List<String> serverUris = Arrays.asList(serverUrisString.trim().split("\\s"));
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(serverUris).multiThreaded(true)).readTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.read_timeout", (int)60000))).connTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.connection_timeout", (int)3000))).maxTotalConnection(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.max_total_connection", (int)20)).defaultMaxTotalConnectionPerRoute(ConfigurationParseHelper.getIntValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.max_total_connection_per_route", (int)2)).discoveryEnabled(ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.discovery.enabled", (boolean)false))).discoveryFrequency(ConfigurationParseHelper.getLongValue((Properties)properties, (String)"hibernate.search.default.elasticsearch.discovery.refresh_interval", (long)10L), TimeUnit.SECONDS)).gson(this.gsonService.getGson());
        String username = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.default.elasticsearch.username", null);
        if (username != null) {
            String password = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.default.elasticsearch.password", null);
            if (password != null) {
                this.warnPasswordsOverHttp(serverUris);
            }
            builder = builder.defaultCredentials(username, password);
        }
        factory.setHttpClientConfig(builder.build());
        this.client = factory.getObject();
    }

    private boolean warnPasswordsOverHttp(Collection<String> serverUris) {
        for (String serverUriAsString : serverUris) {
            URI uri = URI.create(serverUriAsString);
            if (!HTTP_SCHEME.equals(uri.getScheme())) continue;
            LOG.usingPasswordOverHttp(serverUriAsString);
        }
        return false;
    }

    public void stop() {
        this.client.shutdownClient();
        this.client = null;
        this.jestAPIFormatter = null;
        this.serviceManager.releaseService(JestAPIFormatter.class);
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    public <T extends JestResult> T executeRequest(Action<T> request) {
        return (T)this.executeRequest(request, this.defaultResultAssessor);
    }

    public <T extends JestResult> T executeRequest(Action<T> request, BackendRequestResultAssessor<? super T> resultAssessor) {
        try {
            JestResult result = this.client.execute(request);
            resultAssessor.checkSuccess(request, result);
            return (T)result;
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.jestAPIFormatter.formatRequest(request), null, e);
        }
    }

    public Map<BackendRequest<?>, BulkResult.BulkResultItem> executeBulkRequest(List<BackendRequest<?>> backendRequests, boolean refresh) {
        Bulk.Builder bulkBuilder = (Bulk.Builder)new Bulk.Builder().setParameter("refresh", (Object)refresh);
        for (BackendRequest<?> backendRequest : backendRequests) {
            bulkBuilder.addAction((BulkableAction)backendRequest.getAction());
        }
        Bulk request = bulkBuilder.build();
        try {
            BulkResult response = (BulkResult)this.client.execute((Action)request);
            HashMap successfulItems = CollectionHelper.newHashMap((int)backendRequests.size());
            ArrayList<BackendRequest<? extends JestResult>> erroneousItems = new ArrayList<BackendRequest<? extends JestResult>>();
            int i = 0;
            for (BulkResult.BulkResultItem resultItem : response.getItems()) {
                BackendRequest<?> backendRequest = backendRequests.get(i);
                if (backendRequest.getResultAssessor().isSuccess(resultItem)) {
                    successfulItems.put(backendRequest, resultItem);
                } else {
                    erroneousItems.add(backendRequest);
                }
                ++i;
            }
            if (!erroneousItems.isEmpty()) {
                throw LOG.elasticsearchBulkRequestFailed(this.jestAPIFormatter.formatRequest((Action<?>)request), this.jestAPIFormatter.formatResult((JestResult)response), successfulItems, erroneousItems);
            }
            return successfulItems;
        }
        catch (IOException e) {
            throw LOG.elasticsearchRequestFailed(this.jestAPIFormatter.formatRequest((Action<?>)request), null, e);
        }
    }
}

