/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.BulkResult;
import org.hibernate.search.elasticsearch.client.impl.BackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.DefaultBackendRequestResultAssessor;
import org.hibernate.search.elasticsearch.impl.JestAPIFormatter;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DeleteByQueryResultAssessor
implements BackendRequestResultAssessor<JestResult> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final int NOT_FOUND_HTTP_STATUS_CODE = 404;
    private final JestAPIFormatter formatter;
    private final DefaultBackendRequestResultAssessor delegate;

    public DeleteByQueryResultAssessor(JestAPIFormatter formatter) {
        this.formatter = formatter;
        this.delegate = DefaultBackendRequestResultAssessor.builder(formatter).ignoreErrorStatuses(404).build();
    }

    @Override
    public void checkSuccess(Action<? extends JestResult> request, JestResult result) throws SearchException {
        this.delegate.checkSuccess(request, result);
        if (result.getResponseCode() == 404) {
            throw LOG.elasticsearchRequestDeleteByQueryNotFound(this.formatter.formatRequest(request), this.formatter.formatResult(result));
        }
    }

    @Override
    public boolean isSuccess(BulkResult.BulkResultItem bulkResultItem) {
        throw new AssertionFailure("This method should never be called, because DeleteByQuery actions are not Bulkable");
    }
}

