/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.translation;

import com.google.gson.JsonElement;
import java.util.Map;
import org.hibernate.search.elasticsearch.settings.impl.translation.DefaultElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.elasticsearch.settings.impl.translation.ParameterValueTransformer;

class MapParameterValueTransformer
implements ParameterValueTransformer {
    private final Class<?> factoryClass;
    private final String parameterName;
    private final Map<String, JsonElement> translations;

    public MapParameterValueTransformer(Class<?> factoryClass, String parameterName, Map<String, JsonElement> translations) {
        this.factoryClass = factoryClass;
        this.parameterName = parameterName;
        this.translations = translations;
    }

    @Override
    public JsonElement transform(String parameterValue) {
        JsonElement translatedValue = this.translations.get(parameterValue);
        if (translatedValue == null) {
            throw DefaultElasticsearchAnalyzerDefinitionTranslator.LOG.unsupportedAnalysisDefinitionParameterValue(this.factoryClass, this.parameterName, parameterValue);
        }
        return translatedValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.factoryClass + "," + this.parameterName + "," + this.translations + "]";
    }
}

