/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import org.hibernate.search.elasticsearch.util.impl.ParentPathMismatchException;
import org.hibernate.search.exception.AssertionFailure;

public class PathComponentExtractor
implements Cloneable {
    private static final String PATH_COMPONENT_SEPARATOR = ".";
    private StringBuilder path = new StringBuilder();
    private int currentIndexInPath = 0;

    public void append(String pathPart) {
        this.path.append(pathPart);
    }

    public void appendRelativePart(String otherPath) throws ParentPathMismatchException {
        String pathAsString = this.path.toString();
        if (!otherPath.startsWith(pathAsString)) {
            throw new ParentPathMismatchException(pathAsString, otherPath);
        }
        this.path.append(otherPath, this.path.length(), otherPath.length());
    }

    public String next(ConsumptionLimit consumeLimit) {
        int nextSeparatorIndex = this.path.indexOf(PATH_COMPONENT_SEPARATOR, this.currentIndexInPath);
        if (nextSeparatorIndex >= 0) {
            String childName = this.path.substring(this.currentIndexInPath, nextSeparatorIndex);
            this.currentIndexInPath = nextSeparatorIndex + 1;
            return childName;
        }
        if (ConsumptionLimit.LAST.equals((Object)consumeLimit) && this.currentIndexInPath < this.path.length()) {
            String lastComponent = this.path.substring(this.currentIndexInPath);
            this.currentIndexInPath = this.path.length();
            return lastComponent;
        }
        return null;
    }

    public void flushTo(ConsumptionLimit consumeLimit) {
        if (ConsumptionLimit.LAST.equals((Object)consumeLimit)) {
            this.currentIndexInPath = this.path.length();
        } else {
            int nextSeparatorIndex = this.path.lastIndexOf(PATH_COMPONENT_SEPARATOR);
            if (nextSeparatorIndex >= 0) {
                this.currentIndexInPath = nextSeparatorIndex + 1;
            }
        }
    }

    public void reset() {
        this.path.delete(0, this.path.length());
        this.currentIndexInPath = 0;
    }

    public String getLastComponentAbsolutePath() {
        return this.currentIndexInPath == 0 ? null : this.path.substring(0, this.currentIndexInPath - 1);
    }

    public PathComponentExtractor clone() {
        try {
            PathComponentExtractor clone = (PathComponentExtractor)super.clone();
            clone.path = new StringBuilder(this.path);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionFailure("Unexpected clone() failure", (Throwable)e);
        }
    }

    public String toString() {
        return new StringBuilder(this.path).insert(this.currentIndexInPath, "[]").toString();
    }

    public static enum ConsumptionLimit {
        SECOND_BUT_LAST,
        LAST;

    }
}

