/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Session;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.test.AlternateDocument;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.SerializationTestHelper;
import org.junit.Test;

public class QuerySerializationTest
extends SearchTestCase {
    @Test
    public void testQueryObjectIsSerializable() throws IOException, ClassNotFoundException {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        Document document = new Document("Hibernate OGM in Action", "Cloud mapping with Hibernate", "blah blah cloud blah cloud");
        s.persist((Object)document);
        s.getTransaction().commit();
        s.close();
        TermQuery query = new TermQuery(new Term("Abstract", "hibernate"));
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        HSQuery hsQuery = searchFactory.createHSQuery().luceneQuery((Query)query).targetedEntities(new ArrayList());
        int size = this.extractResultSize(hsQuery);
        QuerySerializationTest.assertEquals((String)"Should have found a match", (int)1, (int)size);
        HSQuery hsQueryDuplicate = (HSQuery)SerializationTestHelper.duplicateBySerialization(hsQuery);
        hsQueryDuplicate.afterDeserialise(searchFactory);
        int sizeOfDuplicate = this.extractResultSize(hsQueryDuplicate);
        QuerySerializationTest.assertEquals((String)"Should have found a match", (int)1, (int)sizeOfDuplicate);
    }

    private int extractResultSize(HSQuery hsQuery) {
        DocumentExtractor documentExtractor = hsQuery.queryDocumentExtractor();
        TopDocs topDocs = documentExtractor.getTopDocs();
        documentExtractor.close();
        return topDocs.totalHits;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, AlternateDocument.class};
    }
}

