/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.common;

import java.io.InputStream;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCase;

public abstract class MultipleSessionsSearchTestCase
extends SearchTestCase {
    private static final String masterCopy = "/master/copy";
    private static final String masterMain = "/master/main";
    private static final String slave = "/slave";
    protected static SessionFactory slaveSessionFactory;
    private Configuration commonCfg;

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", this.getBaseIndexDir().getAbsolutePath() + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath() + masterMain);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-master");
    }

    protected void commonConfigure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.sourceBase", this.getBaseIndexDir().getAbsolutePath() + masterCopy);
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath() + slave);
        cfg.setProperty("hibernate.search.default.refresh", "1");
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.buildCommonSessionFactory();
    }

    @Override
    public void tearDown() throws Exception {
        if (slaveSessionFactory != null) {
            slaveSessionFactory.close();
        }
        super.tearDown();
    }

    private void buildCommonSessionFactory() throws Exception {
        if (MultipleSessionsSearchTestCase.getSlaveSessionFactory() != null) {
            MultipleSessionsSearchTestCase.getSlaveSessionFactory().close();
        }
        this.setCommonCfg(new Configuration());
        this.commonConfigure(this.commonCfg);
        if (this.recreateSchema()) {
            this.commonCfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        }
        for (String aPackage : this.getCommonAnnotatedPackages()) {
            this.getCommonConfiguration().addPackage(aPackage);
        }
        for (Class<?> aClass : this.getCommonAnnotatedClasses()) {
            this.getCommonConfiguration().addAnnotatedClass((Class)aClass);
        }
        for (String xmlFile : this.getCommonXmlFiles()) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
            this.getCommonConfiguration().addInputStream(is);
        }
        slaveSessionFactory = this.getCommonConfiguration().buildSessionFactory();
    }

    private void setCommonCfg(Configuration configuration) {
        this.commonCfg = configuration;
    }

    protected Configuration getCommonConfiguration() {
        return this.commonCfg;
    }

    protected Session getSlaveSession() {
        return slaveSessionFactory.openSession();
    }

    protected static SessionFactory getSlaveSessionFactory() {
        return slaveSessionFactory;
    }

    private String[] getCommonAnnotatedPackages() {
        return new String[0];
    }

    private String[] getCommonXmlFiles() {
        return new String[0];
    }

    @Override
    protected abstract Class<?>[] getAnnotatedClasses();

    protected abstract Class<?>[] getCommonAnnotatedClasses();
}

