/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.master;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.BackendMessage;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.jms.master.TShirt;
import org.jgroups.JChannel;
import org.jgroups.Message;

public class JGroupsMasterTest
extends SearchTestCase {
    public static final String CHANNEL_NAME = UUID.randomUUID().toString();
    private JChannel channel;

    public void testMessageSending() throws Exception {
        TShirt shirt = this.createObjectWithSQL();
        List<LuceneWork> queue = this.createDocumentAndWorkQueue(shirt);
        this.sendMessage(queue);
        Thread.sleep(400L);
        FullTextSession ftSess = Search.getFullTextSession((Session)this.openSession());
        ftSess.getTransaction().begin();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.stopAnalyzer);
        Query luceneQuery = parser.parse("logo:jboss");
        FullTextQuery query = ftSess.createFullTextQuery(luceneQuery, new Class[0]);
        List result = query.list();
        JGroupsMasterTest.assertEquals((int)1, (int)result.size());
        ftSess.delete(result.get(0));
        ftSess.getTransaction().commit();
        ftSess.close();
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(this.prepareJGroupsConfigurationString());
        this.channel.connect(CHANNEL_NAME);
    }

    private void sendMessage(List<LuceneWork> queue) throws Exception {
        String indexManagerName = "org.hibernate.search.test.jms.master.TShirt";
        IndexManager indexManager = this.getSearchFactoryImpl().getAllIndexesManager().getIndexManager("org.hibernate.search.test.jms.master.TShirt");
        byte[] data = indexManager.getSerializer().toSerializedModel(queue);
        BackendMessage wrapper = new BackendMessage("org.hibernate.search.test.jms.master.TShirt", data);
        Message message = new Message(null, null, (Object)wrapper);
        this.channel.send(message);
    }

    private List<LuceneWork> createDocumentAndWorkQueue(TShirt shirt) {
        Document doc = new Document();
        Field field = new Field("_hibernate_class", shirt.getClass().getName(), Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("id", "1", Field.Store.YES, Field.Index.NOT_ANALYZED);
        doc.add((Fieldable)field);
        field = new Field("logo", shirt.getLogo(), Field.Store.NO, Field.Index.ANALYZED);
        doc.add((Fieldable)field);
        NumericField numField = new NumericField("length");
        numField.setDoubleValue(shirt.getLength());
        doc.add((Fieldable)numField);
        AddLuceneWork luceneWork = new AddLuceneWork((Serializable)Integer.valueOf(shirt.getId()), String.valueOf(shirt.getId()), shirt.getClass(), doc);
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>();
        queue.add((LuceneWork)luceneWork);
        return queue;
    }

    private TShirt createObjectWithSQL() {
        Session s = this.openSession();
        s.getTransaction().begin();
        TShirt ts = new TShirt();
        ts.setId(1);
        ts.setLogo("JBoss balls");
        ts.setSize("large");
        ts.setLength(23.2);
        s.persist((Object)ts);
        s.getTransaction().commit();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        fullTextSession.beginTransaction();
        fullTextSession.purge(TShirt.class, (Serializable)Integer.valueOf(1));
        fullTextSession.getTransaction().commit();
        s.close();
        return ts;
    }

    @Override
    public void setUp() throws Exception {
        this.prepareJGroupsChannel();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsMaster");
        cfg.setProperty("hibernate.search.default.worker.backend.jgroups.clusterName", CHANNEL_NAME);
        cfg.setProperty("hibernate.search.default.worker.backend.jgroups.configurationString", this.prepareJGroupsConfigurationString());
    }

    private String prepareJGroupsConfigurationString() {
        return "SHARED_LOOPBACK:PING(timeout=500;num_initial_members=2):FD(timeout=2000):VERIFY_SUSPECT(timeout=2000):pbcast.NAKACK(gc_lag=10;retransmit_timeout=3000):UNICAST(timeout=5000):FRAG:pbcast.GMS(join_timeout=300;shun=false;print_local_addr=true)";
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }
}

