/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.util.List;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.impl.jgroups.BackendMessage;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;

public class JGroupsReceiver
extends ReceiverAdapter {
    public static int queues;
    public static int works;
    private SearchFactoryImplementor searchFactory;

    public JGroupsReceiver(SearchFactoryImplementor searchFactory) {
        this.searchFactory = searchFactory;
    }

    public static void reset() {
        queues = 0;
        works = 0;
    }

    public void receive(Message message) {
        try {
            BackendMessage received = (BackendMessage)message.getObject();
            IndexManager indexManager = this.searchFactory.getAllIndexesManager().getIndexManager(received.indexName);
            List queue = indexManager.getSerializer().toLuceneWorks(received.queue);
            ++queues;
            works += queue.size();
        }
        catch (ClassCastException e) {
            throw new SearchException((Throwable)e);
        }
    }
}

