/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.nullValues;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.query.ProjectionToMapResultTransformer;
import org.hibernate.search.test.query.nullValues.ProgrammaticConfiguredValue;
import org.hibernate.transform.ResultTransformer;

public class ProgrammaticIndexAndQueryNullTest
extends SearchTestCase {
    public void testProjectedValueGetsConvertedToNull() throws Exception {
        ProgrammaticConfiguredValue nullValue = new ProgrammaticConfiguredValue(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        QueryParser parser = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
        parser.setAllowLeadingWildcard(true);
        Query query = parser.parse("*");
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{ProgrammaticConfiguredValue.class});
        fullTextQuery.setProjection(new String[]{"id", "value", "__HSearch_Document"});
        fullTextQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List mappedResults = fullTextQuery.list();
        ProgrammaticIndexAndQueryNullTest.assertTrue((String)"Wrong result size", (mappedResults.size() == 1 ? 1 : 0) != 0);
        Map map = (Map)mappedResults.get(0);
        Integer id = (Integer)map.get("id");
        ProgrammaticIndexAndQueryNullTest.assertNotNull((Object)id);
        String value = (String)map.get("value");
        ProgrammaticIndexAndQueryNullTest.assertEquals((String)"The null token should be converted back to null", null, (String)value);
        Document doc = (Document)map.get("__HSearch_Document");
        ProgrammaticIndexAndQueryNullTest.assertEquals((String)"The programmatically configured null value should be in the document", (String)"@null@", (String)doc.getField("value").stringValue());
        tx.commit();
        fullTextSession.close();
    }

    private SearchMapping createSearchMapping() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(ProgrammaticConfiguredValue.class).indexed().property("id", ElementType.FIELD).documentId().name("id").property("value", ElementType.FIELD).field().store(Store.YES).indexNullAs("@null@");
        return mapping;
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.getProperties().put("hibernate.search.model_mapping", this.createSearchMapping());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{ProgrammaticConfiguredValue.class};
    }
}

