/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.util.impl.FileHelper;

public class FSDirectoryTest
extends SearchTestCase {
    public void testEventIntegration() throws Exception {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Documents"));
        try {
            org.apache.lucene.document.Document doc;
            TermDocs docs;
            int num;
            IndexReader reader = IndexReader.open((Directory)dir, (boolean)true);
            try {
                int num2 = reader.numDocs();
                FSDirectoryTest.assertEquals((int)1, (int)num2);
                TermDocs docs2 = reader.termDocs(new Term("Abstract", "hibernate"));
                FSDirectoryTest.assertTrue((boolean)docs2.next());
                org.apache.lucene.document.Document doc2 = reader.document(docs2.doc());
                FSDirectoryTest.assertFalse((boolean)docs2.next());
                docs2 = reader.termDocs(new Term("title", "action"));
                FSDirectoryTest.assertTrue((boolean)docs2.next());
                doc2 = reader.document(docs2.doc());
                FSDirectoryTest.assertFalse((boolean)docs2.next());
                FSDirectoryTest.assertEquals((String)"1", (String)doc2.getFieldable("id").stringValue());
            }
            finally {
                reader.close();
            }
            s = this.getSessions().openSession();
            s.getTransaction().begin();
            Document entity = (Document)s.get(Document.class, (Serializable)Long.valueOf(1L));
            entity.setSummary("Object/relational mapping with EJB3");
            s.persist((Object)new Document("Seam in Action", "", "blah blah blah blah"));
            s.getTransaction().commit();
            s.close();
            reader = IndexReader.open((Directory)dir, (boolean)true);
            try {
                num = reader.numDocs();
                FSDirectoryTest.assertEquals((int)2, (int)num);
                docs = reader.termDocs(new Term("Abstract", "ejb"));
                FSDirectoryTest.assertTrue((boolean)docs.next());
                doc = reader.document(docs.doc());
                FSDirectoryTest.assertFalse((boolean)docs.next());
            }
            finally {
                reader.close();
            }
            s = this.getSessions().openSession();
            s.getTransaction().begin();
            s.delete((Object)entity);
            s.getTransaction().commit();
            s.close();
            reader = IndexReader.open((Directory)dir, (boolean)true);
            try {
                num = reader.numDocs();
                FSDirectoryTest.assertEquals((int)1, (int)num);
                docs = reader.termDocs(new Term("title", "seam"));
                FSDirectoryTest.assertTrue((boolean)docs.next());
                doc = reader.document(docs.doc());
                FSDirectoryTest.assertFalse((boolean)docs.next());
                FSDirectoryTest.assertEquals((String)"2", (String)doc.getFieldable("id").stringValue());
            }
            finally {
                reader.close();
            }
        }
        finally {
            dir.close();
        }
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.delete(s.createCriteria(Document.class).uniqueResult());
        s.getTransaction().commit();
        s.close();
    }

    public void testBoost() throws Exception {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object and Relational", "blah blah blah"));
        s.persist((Object)new Document("Object and Relational", "Hibernate in Action", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Documents"));
        IndexReader indexReader = IndexReader.open((Directory)dir, (boolean)true);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        try {
            QueryParser qp = new QueryParser(TestConstants.getTargetLuceneVersion(), "id", TestConstants.standardAnalyzer);
            Query query = qp.parse("title:Action OR Abstract:Action");
            TopDocs hits = searcher.search(query, 1000);
            FSDirectoryTest.assertEquals((int)2, (int)hits.totalHits);
            FSDirectoryTest.assertTrue((hits.scoreDocs[0].score == 2.0f * hits.scoreDocs[1].score ? 1 : 0) != 0);
            org.apache.lucene.document.Document doc = searcher.doc(0);
            FSDirectoryTest.assertEquals((String)"Hibernate in Action", (String)doc.get("title"));
        }
        finally {
            searcher.close();
            indexReader.close();
            dir.close();
        }
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        List list = s.createQuery("from Document").list();
        for (Document document : list) {
            s.delete((Object)document);
        }
        s.getTransaction().commit();
        s.close();
        this.getSessions().close();
    }

    public void testSearchOnDeletedIndex() throws Exception {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate Search in Action", "", ""));
        s.getTransaction().commit();
        s.close();
        FSDirectory dir = FSDirectory.open((File)new File(this.getBaseIndexDir(), "Documents"));
        IndexReader indexReader = IndexReader.open((Directory)dir, (boolean)true);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        FileHelper.delete((File)this.getBaseIndexDir());
        TermQuery query = new TermQuery(new Term("title", "action"));
        TopDocs hits = searcher.search((Query)query, 1000);
        FSDirectoryTest.assertEquals((int)1, (int)hits.totalHits);
        org.apache.lucene.document.Document doc = searcher.doc(0);
        FSDirectoryTest.assertEquals((String)"Hibernate Search in Action", (String)doc.get("title"));
        searcher.close();
        indexReader.close();
        dir.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        File sub = this.getBaseIndexDir();
        cfg.setProperty("hibernate.search.default.indexBase", sub.getAbsolutePath());
        cfg.setProperty("hibernate.search.default.directory_provider", "filesystem");
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }
}

