/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;

public class TransactionTest
extends SearchTestCase {
    public void testTransactionCommit() throws Exception {
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.persist((Object)new Document("Lucene in Action", "FullText search engine", "blah blah blah"));
        s.persist((Object)new Document("Hibernate Search in Action", "ORM and FullText search engine", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        TransactionTest.assertEquals((String)"transaction.commit() should index", (int)3, (int)this.getDocumentNumber());
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Java Persistence with Hibernate", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.flush();
        s.getTransaction().rollback();
        s.close();
        TransactionTest.assertEquals((String)"rollback() should not index", (int)3, (int)this.getDocumentNumber());
        s = this.getSessions().openSession();
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                connection.setAutoCommit(true);
            }
        });
        s.persist((Object)new Document("Java Persistence with Hibernate", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.flush();
        s.close();
        TransactionTest.assertEquals((String)"no transaction should index", (int)4, (int)this.getDocumentNumber());
    }

    private int getDocumentNumber() throws IOException {
        IndexReader reader = IndexReader.open((Directory)this.getDirectory(Document.class), (boolean)false);
        try {
            int n = reader.numDocs();
            return n;
        }
        finally {
            reader.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class};
    }
}

