/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backend;

import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.test.Clock;
import org.hibernate.search.test.SearchTestCase;
import org.junit.Test;

public class OptimizationTriggerTest
extends SearchTestCase {
    @Test
    public void testOptimizationIsTriggered() throws InterruptedException {
        DirectoryBasedIndexManager indexManager = this.getSingleIndexManager(Clock.class);
        OptimizerStrategy optimizerStrategy = indexManager.getOptimizerStrategy();
        Assert.assertTrue((String)"Unexpected optimizer strategy", (boolean)(optimizerStrategy instanceof IncrementalOptimizerStrategy));
        IncrementalOptimizerStrategy strategy = (IncrementalOptimizerStrategy)optimizerStrategy;
        OptimizationTriggerTest.assertEquals((String)"Initially no optimisation should have been performed", (long)0L, (long)strategy.getOptimizationsPerformed());
        Session session = this.openSession();
        long optimizationsPerformed = 0L;
        int i = 0;
        while (i < 20) {
            Clock c = new Clock(i, "hwd" + i);
            Transaction transaction = session.beginTransaction();
            session.persist((Object)c);
            transaction.commit();
            session.clear();
            optimizationsPerformed = strategy.getOptimizationsPerformed();
            OptimizationTriggerTest.assertEquals((String)"Optimization should be triggered every three inserts", (long)((i + 1) / 3), (long)optimizationsPerformed);
            ++i;
        }
        session.close();
        session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{Clock.class});
        int resultSize = fullTextQuery.getResultSize();
        OptimizationTriggerTest.assertEquals((String)"Wrong number of indexed entities", (int)20, (int)resultSize);
        OptimizationTriggerTest.assertEquals((String)"Optimization should not have changed", (long)optimizationsPerformed, (long)strategy.getOptimizationsPerformed());
        fullTextSession.getSearchFactory().optimize(Clock.class);
        OptimizationTriggerTest.assertEquals((String)"Optimize should have been incremented", (long)(optimizationsPerformed + 1L), (long)strategy.getOptimizationsPerformed());
        fullTextSession.createIndexer(new Class[]{Clock.class}).optimizeAfterPurge(true).optimizeOnFinish(true).startAndWait();
        OptimizationTriggerTest.assertEquals((String)"The mass indexer should trigger optimize as well ", (long)(optimizationsPerformed + 3L), (long)strategy.getOptimizationsPerformed());
        session.close();
    }

    private DirectoryBasedIndexManager getSingleIndexManager(Class<?> clazz) {
        MutableSearchFactory searchFactory = (MutableSearchFactory)this.getSearchFactory();
        EntityIndexBinder indexBindingForEntity = searchFactory.getIndexBindingForEntity(clazz);
        IndexManager[] indexManagers = indexBindingForEntity.getIndexManagers();
        OptimizationTriggerTest.assertEquals((int)1, (int)indexManagers.length);
        return (DirectoryBasedIndexManager)indexManagers[0];
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.optimizer.operation_limit.max", "3");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }
}

