/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import java.io.Serializable;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.batchindexing.LegacyCar;
import org.hibernate.search.test.batchindexing.LegacyCarPlant;
import org.hibernate.search.test.batchindexing.LegacyCarPlantPK;
import org.hibernate.search.test.batchindexing.LegacyTire;

public class CollectionInitializeTest
extends SearchTestCase {
    public void testMassIndexing() throws InterruptedException {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.initializeData(fullTextSession);
        try {
            List list = fullTextSession.createCriteria(LegacyCarPlant.class).list();
            Assert.assertEquals((int)1, (int)list.size());
            fullTextSession.createIndexer(new Class[]{LegacyCarPlant.class}).startAndWait();
            int resultSize = fullTextSession.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[]{LegacyCarPlant.class}).getResultSize();
            Assert.assertEquals((int)1, (int)resultSize);
        }
        finally {
            this.clearData(fullTextSession);
            fullTextSession.close();
        }
    }

    private void clearData(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LegacyCarPlantPK id = new LegacyCarPlantPK();
        id.setCarId("1");
        id.setPlantId("2");
        fullTextSession.delete(fullTextSession.get(LegacyCarPlant.class, (Serializable)id));
        int i = 1;
        while (i < 4) {
            fullTextSession.delete(fullTextSession.get(LegacyCar.class, (Serializable)((Object)("" + i))));
            ++i;
        }
        transaction.commit();
    }

    private void initializeData(FullTextSession fullTextSession) {
        Transaction transaction = fullTextSession.beginTransaction();
        LegacyCar[] cars = new LegacyCar[3];
        int i = 1;
        while (i < 4) {
            cars[i - 1] = new LegacyCar();
            cars[i - 1].setId("" + i);
            cars[i - 1].setModel("model" + i);
            fullTextSession.persist((Object)cars[i - 1]);
            ++i;
        }
        LegacyCarPlant plant = new LegacyCarPlant();
        plant.setCar(cars[0]);
        plant.setName("plant12");
        plant.setId(new LegacyCarPlantPK());
        plant.getId().setCarId(cars[0].getId());
        plant.getId().setPlantId("2");
        fullTextSession.persist((Object)plant);
        transaction.commit();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{LegacyCarPlant.class, LegacyCar.class, LegacyTire.class};
    }
}

