/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.test.batchindexing.LegacyCarPlantPK;

public class LegacyCarPlantPKBridge
implements TwoWayFieldBridge {
    private static final String PLANT_ID = ".plantId";
    private static final String CAR_ID = ".carId";

    public Object get(String name, Document document) {
        LegacyCarPlantPK id = new LegacyCarPlantPK();
        Fieldable field = document.getFieldable(String.valueOf(name) + PLANT_ID);
        id.setPlantId(field.stringValue());
        field = document.getFieldable(String.valueOf(name) + CAR_ID);
        id.setCarId(field.stringValue());
        return id;
    }

    public String objectToString(Object o) {
        LegacyCarPlantPK id = (LegacyCarPlantPK)o;
        StringBuilder sb = new StringBuilder();
        sb.append(id.getPlantId()).append("-").append(id.getCarId());
        return sb.toString();
    }

    public void set(String name, Object o, Document document, LuceneOptions luceneOptions) {
        LegacyCarPlantPK id = (LegacyCarPlantPK)o;
        Field.Store store = luceneOptions.getStore();
        Field.Index index = luceneOptions.getIndex();
        Field.TermVector termVector = luceneOptions.getTermVector();
        Float boost = Float.valueOf(luceneOptions.getBoost());
        Field field = new Field(String.valueOf(name) + PLANT_ID, id.getPlantId(), store, index, termVector);
        field.setBoost(boost.floatValue());
        document.add((Fieldable)field);
        field = new Field(String.valueOf(name) + CAR_ID, id.getCarId(), store, index, termVector);
        field.setBoost(boost.floatValue());
        document.add((Fieldable)field);
    }
}

