/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.batchindexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.test.batchindexing.LegacyTirePK;

public class LegacyTirePKBridge
implements TwoWayFieldBridge {
    private static final String CAR_ID = ".carId";
    private static final String TIRE_ID = ".tireId";

    public Object get(String name, Document document) {
        LegacyTirePK id = new LegacyTirePK();
        Fieldable field = document.getFieldable(String.valueOf(name) + CAR_ID);
        id.setCarId(field.stringValue());
        field = document.getFieldable(String.valueOf(name) + TIRE_ID);
        id.setTireId(field.stringValue());
        return id;
    }

    public String objectToString(Object o) {
        LegacyTirePK id = (LegacyTirePK)o;
        return id.getCarId() + "-" + id.getTireId();
    }

    public void set(String name, Object o, Document document, LuceneOptions luceneOptions) {
        LegacyTirePK id = (LegacyTirePK)o;
        luceneOptions.addFieldToDocument(String.valueOf(name) + CAR_ID, id.getCarId(), document);
        luceneOptions.addFieldToDocument(String.valueOf(name) + TIRE_ID, id.getTireId(), document);
    }
}

