/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.norms;

import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.util.LeakingLuceneBackend;

public class StoreNormsTest
extends SearchTestCase {
    public void testStoreAndOmitNorms() throws Exception {
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        Transaction tx = fullTextSession.beginTransaction();
        NormsTestEntity test = new NormsTestEntity();
        test.setWithNormsImplicit("hello");
        test.setWithNormsExplicit("world");
        test.setWithoutNorms("how are you?");
        fullTextSession.save((Object)test);
        tx.commit();
        List processedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        StoreNormsTest.assertTrue((processedQueue.size() == 1 ? 1 : 0) != 0);
        AddLuceneWork addLuceneWork = (AddLuceneWork)processedQueue.get(0);
        Document doc = addLuceneWork.getDocument();
        Fieldable implicitNormField = doc.getFieldable("withNormsImplicit");
        StoreNormsTest.assertFalse((String)"norms should be stored for this field", (boolean)implicitNormField.getOmitNorms());
        Fieldable explicitNormField = doc.getFieldable("withNormsExplicit");
        StoreNormsTest.assertFalse((String)"norms should be stored for this field", (boolean)explicitNormField.getOmitNorms());
        Fieldable withoutNormField = doc.getFieldable("withoutNorms");
        StoreNormsTest.assertTrue((String)"norms should not be stored for this field", (boolean)withoutNormField.getOmitNorms());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{NormsTestEntity.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }

    @Entity
    @Indexed(index="test")
    public class NormsTestEntity {
        @Id
        @GeneratedValue
        private int id;
        @Field(store=Store.YES)
        private String withNormsImplicit;
        @Field(norms=Norms.YES, store=Store.YES)
        private String withNormsExplicit;
        @Field(norms=Norms.NO, store=Store.YES)
        private String withoutNorms;

        public String getWithNormsImplicit() {
            return this.withNormsImplicit;
        }

        public void setWithNormsImplicit(String withNormsImplicit) {
            this.withNormsImplicit = withNormsImplicit;
        }

        public String getWithNormsExplicit() {
            return this.withNormsExplicit;
        }

        public void setWithNormsExplicit(String withNormsExplicit) {
            this.withNormsExplicit = withNormsExplicit;
        }

        public String getWithoutNorms() {
            return this.withoutNorms;
        }

        public void setWithoutNorms(String withoutNorms) {
            this.withoutNorms = withoutNorms;
        }
    }
}

