/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.lucene.util.Version;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.search.test.TestConstants;

public abstract class MultipleSFTestCase
extends TestCase {
    private static SessionFactory[] sessionFactories;
    private static Configuration[] cfgs;
    private static Dialect dialect;
    private static Class lastTestClass;

    protected abstract int getSFNbrs();

    protected void buildSessionFactories(Class[] classes, String[] packages, String[] xmlFiles) throws Exception {
        if (sessionFactories == null) {
            sessionFactories = new SessionFactory[this.getSFNbrs()];
        }
        if (cfgs == null) {
            cfgs = new Configuration[this.getSFNbrs()];
        }
        SessionFactory[] sessionFactoryArray = sessionFactories;
        int n = sessionFactories.length;
        int n2 = 0;
        while (n2 < n) {
            SessionFactory sf = sessionFactoryArray[n2];
            if (sf != null) {
                sf.close();
            }
            ++n2;
        }
        int sfIndex = 0;
        while (sfIndex < this.getSFNbrs()) {
            MultipleSFTestCase.cfgs[sfIndex] = new Configuration();
            ++sfIndex;
        }
        this.configure(cfgs);
        sfIndex = 0;
        while (sfIndex < this.getSFNbrs()) {
            try {
                if (this.recreateSchema()) {
                    cfgs[sfIndex].setProperty("hibernate.hbm2ddl.auto", "create-drop");
                }
                Object[] objectArray = packages;
                int n3 = packages.length;
                n = 0;
                while (n < n3) {
                    String aPackage = objectArray[n];
                    cfgs[sfIndex].addPackage(aPackage);
                    ++n;
                }
                objectArray = classes;
                n3 = classes.length;
                n = 0;
                while (n < n3) {
                    Object aClass = objectArray[n];
                    cfgs[sfIndex].addAnnotatedClass((Class)aClass);
                    ++n;
                }
                objectArray = xmlFiles;
                n3 = xmlFiles.length;
                n = 0;
                while (n < n3) {
                    Object xmlFile = objectArray[n];
                    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)xmlFile);
                    cfgs[sfIndex].addInputStream(is);
                    ++n;
                }
                this.setDialect(Dialect.getDialect());
                MultipleSFTestCase.sessionFactories[sfIndex] = cfgs[sfIndex].buildSessionFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            ++sfIndex;
        }
    }

    protected void setUp() throws Exception {
        this.buildSessionFactories(this.getAnnotatedClasses(), this.getAnnotatedPackages(), this.getXmlFiles());
        lastTestClass = ((Object)((Object)this)).getClass();
    }

    protected void tearDown() throws Exception {
        SessionFactory[] sessionFactoryArray = MultipleSFTestCase.getSessionFactories();
        int n = sessionFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionFactory sf = sessionFactoryArray[n2];
            sf.close();
            ++n2;
        }
    }

    protected abstract Class[] getAnnotatedClasses();

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    private void setDialect(Dialect dialect) {
        MultipleSFTestCase.dialect = dialect;
    }

    protected Dialect getDialect() {
        return dialect;
    }

    protected abstract void configure(Configuration[] var1);

    protected boolean recreateSchema() {
        return true;
    }

    public static SessionFactory[] getSessionFactories() {
        return sessionFactories;
    }

    public static Version getTargetLuceneVersion() {
        return TestConstants.getTargetLuceneVersion();
    }
}

