/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.depth;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.depth.Person;
import org.hibernate.search.test.util.LeakingLuceneBackend;

public class RecursiveGraphTest
extends SearchTestCase {
    public void testCorrectDepthIndexed() {
        this.prepareGenealogyTree();
        this.verifyMatchExistsWithName(1L, "name", "John of England");
        this.verifyNoMatchExists("parents.name", "John of England");
        this.verifyMatchExistsWithName(1L, "parents.name", "Henry II of England");
        this.verifyMatchExistsWithName(1L, "parents.parents.name", "Geoffrey V of Anjou");
        this.verifyMatchExistsWithName(2L, "parents.parents.name", "Fulk V of Anjou");
        this.verifyNoMatchExists("parents.parents.parents.name", "Fulk V of Anjou");
        LeakingLuceneBackend.reset();
        this.renamePerson(1L, "John Lackland");
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(1L));
        RecursiveGraphTest.assertEquals((int)0, (int)this.countWorksDoneOnPerson(2L));
        LeakingLuceneBackend.reset();
        this.renamePerson(2L, "Henry II of New England");
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(1L));
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(2L));
        LeakingLuceneBackend.reset();
        this.renamePerson(16L, "Fulk 4th of Anjou");
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(16L));
        RecursiveGraphTest.assertEquals((int)0, (int)this.countWorksDoneOnPerson(17L));
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(8L));
        RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(4L));
        RecursiveGraphTest.assertEquals((int)0, (int)this.countWorksDoneOnPerson(2L));
        RecursiveGraphTest.assertEquals((int)0, (int)this.countWorksDoneOnPerson(1L));
    }

    private void renamePerson(Long id, String newName) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            Person kingJohn = (Person)fullTextSession.load(Person.class, (Serializable)id);
            kingJohn.setName(newName);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    void verifyNoMatchExists(String fieldName, String fieldValue) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            RecursiveGraphTest.assertEquals((int)0, (int)resultSize);
            List list = fullTextQuery.list();
            RecursiveGraphTest.assertEquals((int)0, (int)list.size());
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    void verifyMatchExistsWithName(Long expectedId, String fieldName, String fieldValue) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term(fieldName, fieldValue));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            RecursiveGraphTest.assertEquals((int)1, (int)resultSize);
            List list = fullTextQuery.list();
            RecursiveGraphTest.assertEquals((int)1, (int)list.size());
            RecursiveGraphTest.assertEquals((Object)expectedId, (Object)((Person)list.get(0)).getId());
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    void prepareGenealogyTree() {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Person[] ps = new Person[18];
        ps[1] = new Person(1L, "John of England");
        ps[2] = new Person(2L, "Henry II of England");
        ps[3] = new Person(3L, "Eleanor of Aquitaine");
        ps[4] = new Person(4L, "Geoffrey V of Anjou");
        ps[5] = new Person(5L, "Empress Matilda");
        ps[6] = new Person(6L, "William X of Aquitaine");
        ps[7] = new Person(7L, "Aenor de Ch\u00e2tellerault");
        ps[8] = new Person(8L, "Fulk V of Anjou");
        ps[9] = new Person(9L, "Ermengarde of Maine");
        ps[10] = new Person(10L, "Henry I of England");
        ps[11] = new Person(11L, "Matilda of Scotland");
        ps[12] = new Person(12L, "William IX of Aquitaine");
        ps[13] = new Person(13L, "Philippa of Toulouse");
        ps[14] = new Person(14L, "Aimery I of Ch\u00e2ttellerault");
        ps[15] = new Person(15L, "Dangereuse de L'Isle Bouchard");
        ps[16] = new Person(16L, "Fulk IV of Anjou");
        ps[17] = new Person(17L, "Bertrade de Montfort");
        ps[1].addParents(ps[2], ps[3]);
        ps[2].addParents(ps[4], ps[5]);
        ps[3].addParents(ps[6], ps[7]);
        ps[4].addParents(ps[8], ps[9]);
        ps[5].addParents(ps[10], ps[11]);
        ps[6].addParents(ps[12], ps[13]);
        ps[7].addParents(ps[14], ps[15]);
        ps[8].addParents(ps[16], ps[17]);
        int i = 1;
        while (i < 18) {
            session.save((Object)ps[i]);
            ++i;
        }
        transaction.commit();
        session.close();
        i = 1;
        while (i < 18) {
            RecursiveGraphTest.assertEquals((int)1, (int)this.countWorksDoneOnPerson(Long.valueOf(i)));
            ++i;
        }
    }

    private int countWorksDoneOnPerson(Long pk) {
        List processedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        int count = 0;
        for (LuceneWork luceneWork : processedQueue) {
            Serializable id = luceneWork.getId();
            if (!pk.equals(id)) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }
}

