/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.fieldoncollection;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionItem;
import org.hibernate.search.test.embedded.fieldoncollection.IndexedEntity;

public class FieldOnCollectionReindexationTest
extends SearchTestCase {
    public void testUpdatingCollectionWithFieldAnnotationReindexesEntity() {
        Session hibernateSession = this.openSession();
        IndexedEntity indexedEntity = new IndexedEntity("child");
        CollectionItem item1 = new CollectionItem();
        CollectionItem item2 = new CollectionItem();
        CollectionItem item3 = new CollectionItem();
        Transaction tx = hibernateSession.beginTransaction();
        hibernateSession.save((Object)item1);
        hibernateSession.save((Object)item2);
        hibernateSession.save((Object)item3);
        tx.commit();
        ArrayList<CollectionItem> items = new ArrayList<CollectionItem>();
        items.add(item1);
        items.add(item3);
        indexedEntity.setItemsWithFieldAnnotation(items);
        tx = hibernateSession.beginTransaction();
        hibernateSession.save((Object)indexedEntity);
        tx.commit();
        tx = hibernateSession.beginTransaction();
        List<IndexedEntity> searchResult = this.searchIndexedEntity(hibernateSession, "itemsWithFieldAnnotation", item1);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        searchResult = this.searchIndexedEntity(hibernateSession, "itemsWithFieldAnnotation", item2);
        FieldOnCollectionReindexationTest.assertEquals((int)0, (int)searchResult.size());
        searchResult = this.searchIndexedEntity(hibernateSession, "itemsWithFieldAnnotation", item3);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        tx.commit();
        items.clear();
        items.add(item2);
        indexedEntity.setItemsWithFieldAnnotation(items);
        indexedEntity.setName("new name");
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "itemsWithFieldAnnotation", item2);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        items.clear();
        items.add(item3);
        indexedEntity.setItemsWithFieldAnnotation(items);
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "itemsWithFieldAnnotation", item3);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        hibernateSession.close();
    }

    public void testUpdatingCollectionWithFieldsAnnotationReindexesEntity() {
        Session hibernateSession = this.openSession();
        IndexedEntity indexedEntity = new IndexedEntity("child");
        CollectionItem item1 = new CollectionItem();
        CollectionItem item2 = new CollectionItem();
        CollectionItem item3 = new CollectionItem();
        ArrayList<CollectionItem> items = new ArrayList<CollectionItem>();
        items.add(item1);
        items.add(item3);
        indexedEntity.setItemsWithFieldsAnnotation(items);
        Transaction tx = hibernateSession.beginTransaction();
        hibernateSession.save((Object)item1);
        hibernateSession.save((Object)item2);
        hibernateSession.save((Object)item3);
        hibernateSession.save((Object)indexedEntity);
        tx.commit();
        tx = hibernateSession.beginTransaction();
        List<IndexedEntity> searchResult = this.searchIndexedEntity(hibernateSession, "field1", item1);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        searchResult = this.searchIndexedEntity(hibernateSession, "field1", item2);
        FieldOnCollectionReindexationTest.assertEquals((int)0, (int)searchResult.size());
        searchResult = this.searchIndexedEntity(hibernateSession, "field1", item3);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        tx.commit();
        items.clear();
        items.add(item2);
        indexedEntity.setItemsWithFieldsAnnotation(items);
        indexedEntity.setName("new name");
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "field1", item2);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        items.clear();
        items.add(item3);
        indexedEntity.setItemsWithFieldsAnnotation(items);
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "field1", item3);
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        hibernateSession.close();
    }

    public void testUpdatingElementCollectionWithFieldAnnotationReindexesEntity() {
        Session hibernateSession = this.openSession();
        IndexedEntity indexedEntity = new IndexedEntity("child");
        indexedEntity.addKeyword("test1");
        indexedEntity.addKeyword("test3");
        Transaction tx = hibernateSession.beginTransaction();
        hibernateSession.save((Object)indexedEntity);
        tx.commit();
        tx = hibernateSession.beginTransaction();
        List<IndexedEntity> searchResult = this.searchIndexedEntity(hibernateSession, "keywords", "test1");
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        searchResult = this.searchIndexedEntity(hibernateSession, "keywords", "test2");
        FieldOnCollectionReindexationTest.assertEquals((int)0, (int)searchResult.size());
        searchResult = this.searchIndexedEntity(hibernateSession, "keywords", "test3");
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        tx.commit();
        indexedEntity.addKeyword("test4");
        indexedEntity.setName("new name");
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "keywords", "test4");
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        indexedEntity.addKeyword("test5");
        tx = hibernateSession.beginTransaction();
        hibernateSession.update((Object)indexedEntity);
        tx.commit();
        searchResult = this.searchIndexedEntity(hibernateSession, "keywords", "test5");
        FieldOnCollectionReindexationTest.assertEquals((int)1, (int)searchResult.size());
        FieldOnCollectionReindexationTest.assertEquals((Object)searchResult.iterator().next().getId(), (Object)indexedEntity.getId());
        hibernateSession.close();
    }

    private List<IndexedEntity> searchIndexedEntity(Session session, String field, Object value) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(IndexedEntity.class).get();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(queryBuilder.keyword().onField(field).matching(value).createQuery(), new Class[]{IndexedEntity.class});
        return fullTextQuery.list();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{IndexedEntity.class, CollectionItem.class};
    }
}

