/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.fieldoncollection;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.fieldoncollection.CollectionItem;
import org.hibernate.search.test.embedded.fieldoncollection.Leaf;
import org.hibernate.search.test.embedded.fieldoncollection.Root;

public class LazyIndirectCollectionBridgeReindexTest
extends SearchTestCase {
    public void testLazyIndirectCollectionBridgeReindex() throws InterruptedException {
        this.prepareEntities();
        this.verifyMatchExistsWithName("name", "name");
        Session session = this.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MassIndexer massIndexer = fullTextSession.createIndexer(new Class[]{Root.class});
        massIndexer.startAndWait();
        this.verifyMatchExistsWithName("name", "name");
    }

    private void verifyMatchExistsWithName(String fieldName, String fieldValue) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term("name", "name"));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            LazyIndirectCollectionBridgeReindexTest.assertEquals((int)1, (int)resultSize);
            List list = fullTextQuery.list();
            LazyIndirectCollectionBridgeReindexTest.assertEquals((int)1, (int)list.size());
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    private void prepareEntities() {
        Session session = this.openSession();
        try {
            Transaction transaction = session.beginTransaction();
            CollectionItem bridgedEntity = new CollectionItem();
            session.save((Object)bridgedEntity);
            Leaf leaf = new Leaf();
            leaf.getCollectionItems().add(bridgedEntity);
            session.save((Object)leaf);
            Root root = new Root();
            root.setName("name");
            root.setLeaf(leaf);
            session.save((Object)root);
            transaction.commit();
        }
        finally {
            session.close();
        }
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{CollectionItem.class, Leaf.class, Root.class};
    }
}

