/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.path;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;

@Entity
@Indexed
public class Human {
    public int id;
    public String name;
    public Set<Human> parents = new HashSet<Human>();
    public Human child;
    private String surname;

    public Human() {
    }

    public Human(String name, String surname) {
        this.name = name;
        this.surname = surname;
    }

    public void addParents(Human father, Human mother) {
        this.parents.add(father);
        this.parents.add(mother);
        father.child = this;
        mother.child = this;
    }

    @Transient
    public String getFullname() {
        return String.valueOf(this.name) + " " + this.surname;
    }

    @Id
    @GeneratedValue
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Field(analyze=Analyze.NO)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Field(analyze=Analyze.NO)
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    @OneToMany
    @IndexedEmbedded(depth=2, includePaths={"parents.parents.name"})
    public Set<Human> getParents() {
        return this.parents;
    }

    public void setParents(Set<Human> parents) {
        this.parents = parents;
    }

    @ContainedIn
    @ManyToOne
    public Human getChild() {
        return this.child;
    }

    public void setChild(Human child) {
        this.child = child;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.surname == null ? 0 : this.surname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Human other = (Human)obj;
        if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.surname == null ? other.surname != null : !this.surname.equals(other.surname));
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.surname;
    }
}

