/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.List;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.hibernate.search.test.util.FieldSelectorLeakingReaderProvider;

public class LazyCollectionsUpdatingTest
extends SearchTestCase {
    public void testUpdatingInTransaction() {
        block5: {
            this.assertFindsByRoadName("buonarroti");
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
            try {
                try {
                    Transaction tx = fullTextSession.beginTransaction();
                    FieldSelectorLeakingReaderProvider.resetFieldSelector();
                    List list = fullTextSession.createCriteria(BusStop.class).list();
                    FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
                    LazyCollectionsUpdatingTest.assertNotNull((Object)list);
                    LazyCollectionsUpdatingTest.assertEquals((int)4, (int)list.size());
                    BusStop busStop = (BusStop)list.get(1);
                    busStop.setRoadName("new road");
                    tx.commit();
                }
                catch (AssertionFailure ass) {
                    LazyCollectionsUpdatingTest.fail((String)ass.getMessage());
                    fullTextSession.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                fullTextSession.close();
                throw throwable;
            }
            fullTextSession.close();
        }
        this.assertFindsByRoadName("new");
    }

    public void testUpdatingOutOfTransaction() {
        block5: {
            this.assertFindsByRoadName("buonarroti");
            FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
            try {
                try {
                    List list = fullTextSession.createCriteria(BusStop.class).list();
                    LazyCollectionsUpdatingTest.assertNotNull((Object)list);
                    LazyCollectionsUpdatingTest.assertEquals((int)4, (int)list.size());
                    BusStop busStop = (BusStop)list.get(1);
                    busStop.setRoadName("new road");
                    fullTextSession.flush();
                }
                catch (AssertionFailure ass) {
                    LazyCollectionsUpdatingTest.fail((String)ass.getMessage());
                    fullTextSession.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                fullTextSession.close();
                throw throwable;
            }
            fullTextSession.close();
        }
        this.assertFindsByRoadName("new");
    }

    public void assertFindsByRoadName(String analyzedRoadname) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        Transaction tx = fullTextSession.beginTransaction();
        TermQuery ftQuery = new TermQuery(new Term("stops.roadName", analyzedRoadname));
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)ftQuery, new Class[]{BusLine.class});
        query.setProjection(new String[]{"busLineName"});
        LazyCollectionsUpdatingTest.assertEquals((int)1, (int)query.list().size());
        List results = query.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled((String[])new String[]{"busLineName"});
        String resultName = (String)((Object[])results.get(0))[0];
        LazyCollectionsUpdatingTest.assertEquals((String)"Linea 64", (String)resultName);
        tx.commit();
        fullTextSession.close();
    }

    public void testFieldsAnnotationCalls() {
        BusLine bus;
        block7: {
            this.openSession();
            Transaction tx = null;
            bus = new BusLine();
            try {
                try {
                    tx = this.session.beginTransaction();
                    bus.setBusLineName("Linea 64");
                    LazyCollectionsUpdatingTest.addBusStop(bus, "Stazione Termini");
                    LazyCollectionsUpdatingTest.addBusStop(bus, "via Gregorio VII");
                    LazyCollectionsUpdatingTest.addBusStop(bus, "via Alessandro III");
                    LazyCollectionsUpdatingTest.addBusStop(bus, "via M.Buonarroti");
                    this.session.persist((Object)bus);
                    tx.commit();
                }
                catch (Throwable t) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    this.session.close();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.session.close();
                throw throwable;
            }
            this.session.close();
        }
        for (BusStop stop : bus.getStops()) {
            LazyCollectionsUpdatingTest.assertEquals((String)"@Fields annotation should only call getValue once", (int)1, (int)stop.getNumMethodCalls());
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.openSession();
        Transaction tx = null;
        try {
            try {
                tx = this.session.beginTransaction();
                BusLine bus = new BusLine();
                bus.setBusLineName("Linea 64");
                LazyCollectionsUpdatingTest.addBusStop(bus, "Stazione Termini");
                LazyCollectionsUpdatingTest.addBusStop(bus, "via Gregorio VII");
                LazyCollectionsUpdatingTest.addBusStop(bus, "via Alessandro III");
                LazyCollectionsUpdatingTest.addBusStop(bus, "via M.Buonarroti");
                this.session.persist((Object)bus);
                tx.commit();
            }
            catch (Throwable t) {
                if (tx != null) {
                    tx.rollback();
                }
                this.session.close();
            }
        }
        finally {
            this.session.close();
        }
    }

    static void addBusStop(BusLine bus, String roadName) {
        BusStop stop = new BusStop();
        stop.setRoadName(roadName);
        bus.getStops().add(stop);
        stop.getBusses().add(bus);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    protected void configure(Configuration configuration) {
        super.configure(configuration);
        this.cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        this.cfg.setProperty("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
        this.cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

