/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;

public class RollbackTransactionTest
extends SearchTestCase {
    public void testTransactionBehaviour() {
        RollbackTransactionTest.assertEquals((int)0, (int)this.countBusLinesByFullText());
        RollbackTransactionTest.assertEquals((int)0, (int)this.countBusLineByDatabaseCount());
        this.createBusLines(5, true);
        RollbackTransactionTest.assertEquals((int)0, (int)this.countBusLinesByFullText());
        RollbackTransactionTest.assertEquals((int)0, (int)this.countBusLineByDatabaseCount());
        this.createBusLines(5, false);
        RollbackTransactionTest.assertEquals((int)5, (int)this.countBusLinesByFullText());
        RollbackTransactionTest.assertEquals((int)5, (int)this.countBusLineByDatabaseCount());
        this.createBusLines(7, true);
        RollbackTransactionTest.assertEquals((int)5, (int)this.countBusLinesByFullText());
        RollbackTransactionTest.assertEquals((int)5, (int)this.countBusLineByDatabaseCount());
        this.createBusLines(7, false);
        RollbackTransactionTest.assertEquals((int)12, (int)this.countBusLinesByFullText());
        RollbackTransactionTest.assertEquals((int)12, (int)this.countBusLineByDatabaseCount());
    }

    private void createBusLines(int number, boolean rollback) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        int i = 0;
        while (i < number) {
            BusLine line = new BusLine();
            line.setBusLineName("line " + i);
            fullTextSession.persist((Object)line);
            ++i;
        }
        if (rollback) {
            tx.rollback();
        } else {
            tx.commit();
        }
        fullTextSession.close();
    }

    public int countBusLinesByFullText() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        MatchAllDocsQuery ftQuery = new MatchAllDocsQuery();
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)ftQuery, new Class[]{BusLine.class});
        int count = query.list().size();
        tx.commit();
        fullTextSession.close();
        return count;
    }

    public int countBusLineByDatabaseCount() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        int count = fullTextSession.createCriteria(BusLine.class).list().size();
        tx.commit();
        fullTextSession.close();
        return count;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    protected void configure(Configuration configuration) {
        super.configure(configuration);
        this.cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        this.cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

